#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"

#include <iostream>
#include <vector>
#include <string>

SDFileSystem sd(p5, p6, p7, p20, "sd");  //SD card Slot
AnalogOut DACout(p18);                   //Analog Output
PwmOut sounder(p26);                     //PWM Sounder Output
wave_player waver(&DACout, &sounder);    //wave player object

int main() {
    string DIRPATH("/sd/Music");
    DIR *dir;
    struct dirent *entry;
    FILE *wave_file;
    vector<string> file_list;
    int num_file,i;
    string file_name;
    
    dir = opendir(DIRPATH.c_str());
    if ( dir != NULL ) {
        while ( (entry = readdir(dir)) != NULL ) {
            file_list.push_back(entry -> d_name);
        }
        num_file = file_list.size();
        for(i = 0; i < num_file; i++){
            std::cout << "File No."  << i + 1 << " " << file_list[i] << std::endl;
            }
        sounder.period(1.0/400000.0);
        while(1){
            std::cout << "Input File Number:";
            std::cin >> i;
            file_name = file_name.erase() + DIRPATH + "/" +file_list[i-1];
            wave_file=fopen(file_name.c_str(),"r");
            waver.play(wave_file);
            fclose(wave_file);
        }
    }
    closedir(dir);
    return 0;
}