#include "LCD_DISCO_F429ZI.h"
#include "Led_Lcd.h"
 
LCD_DISCO_F429ZI lcd;
 
LedLcd::LedLcd(unsigned char SetColumn)
{   
    lcd.Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);
    ucColChosen = SetColumn;
}   
 
void LedLcd::On(unsigned char ucLedIndex)
{
    unsigned char ucLoopCounter = 0;
    for (ucLoopCounter = 0 ; ucLoopCounter <= 2 ; ucLoopCounter ++) {
        
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(80*ucLoopCounter,80* ucColChosen,80,80);
        if (ucLoopCounter == ucLedIndex)
            lcd.SetTextColor(LCD_COLOR_YELLOW);    
        else 
            lcd.SetTextColor(LCD_COLOR_BLUE); 
        lcd.FillRect(1 + 80*ucLoopCounter,1 + 80 * ucColChosen,78,78);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayChar(80*ucLoopCounter,80 * ucColChosen , 48 + ucLoopCounter );    
    }
}   

