#include "VL6180X.h"
#include "mbed.h"
#include "m3pi.h"
#include "S11059.h"

VL6180x rf(p28, p27); //I2C sda and scl
Serial pc(USBTX, USBRX); //USB serial
S11059 col(p28,p27);
m3pi m3pi;
Timer t;

int main() {
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("Sensor");
    m3pi.locate(0,1);
    m3pi.printf("Check");
    wait(1);
    int reading;
    float time[2];
    int bl=0;
    char buf[255];
    m3pi.cls();
    rf.VL6180xInit();
    rf.VL6180xDefautSettings();
    
    while(1) {
        m3pi.cls();
        t.start();
        time[0] = t.read();
        rf.triggerDistance();
        reading = rf.pollDistance();
        t.stop();
        time[1] = t.read();
        col.update();
        bl = col.b;     
        int len = 0;
        m3pi.locate(0,0);     
        m3pi.printf("%dmm",reading);

//        m3pi.locate(0,1);
//        m3pi.printf("%d",bl);

        m3pi.locate(0,1);
        m3pi.printf("%.3fms",(time[1]-time[0])*1000);

        pc.printf("Read %d mm\n\r", reading);
        m3pi.print(buf,len);
        wait_ms(100);
    }
}