#include "mbed.h"
#include "ltisys.h"


int main() {
    /*
     the following line is generated by MATLAB by:
        s=tf('s')
        test_sys=[1,1/(s^2+s+1);0.05/s,1/(s+1)]
        impl_ltisys(test_sys,'test_sys')
     check the result by comparing with:
        u=ones(21,1)*[1,2]
        lsim(test_sys,u,0:20)
    */
    ltisys<4,2,2> test_sys((const double []) {-0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,-1.000000e+00,-1.000000e+00,0.000000e+00,0.000000e+00,1.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,-1.000000e+00,},(const double []) {2.500000e-01,0.000000e+00,0.000000e+00,1.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,1.000000e+00,},(const double []) {0.000000e+00,0.000000e+00,1.000000e+00,0.000000e+00,2.000000e-01,0.000000e+00,0.000000e+00,1.000000e+00,},(const double []) {1.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,});

    // calculate step response of test_sys
    double u[] = { 1.0 , 2.0};
    double dt=1.0;
    for (double t = 0; t <= 20.0; t+=dt) {
        test_sys.update(dt, u);
        printf("%f\t%f\t%f\r\n", t, test_sys.y[0],test_sys.y[1]);
    }
}
