#include "S11059.h"

S11059::S11059(PinName sda, PinName scl): _i2c(sda,scl){
    char dat[2];
    dat[0] = 0x00;
    dat[1] = 0x8a;
    _i2c.write(S11059_ADDR,dat,2);
    dat[1] = 0x0a;
    _i2c.write(S11059_ADDR,dat,2);
}

void S11059::update(){
    uint8_t buf[8];
    char dataout[1]={0x03};
    _i2c.write(S11059_ADDR, (char *) dataout, 1);
    _i2c.read(S11059_ADDR, (char *) buf,8);    
    r=buf[0]<<8|buf[1];
    g=buf[2]<<8|buf[3];
    b=buf[4]<<8|buf[5];
}

S11059::~S11059(){
}