#include "S11059-SoftI2C.h"

S11059::S11059(PinName sda, PinName scl): _i2c(sda,scl){
    wait(0.2);
    _i2c.setFrequency(400000);
    _i2c.initialise();
    wait(0.2);
    _i2c.randomWrite(S11059_ADDR,0x00,0x8a);
    _i2c.randomWrite(S11059_ADDR,0x00,0x0a);
    wait(1);    
}

void S11059::update(){
    uint8_t buf[8];     
    _i2c.randomRead(S11059_ADDR,0x03,buf,8);
    r=buf[0]<<8|buf[1];
    g=buf[2]<<8|buf[3];
    b=buf[4]<<8|buf[5];
}

S11059::~S11059(){
}