 #include "mbed.h"
#include "C12832.h"
#include "Sht31.h"
#include <string>
#include "mbed_trace.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"
#include "SX1276_LoRaRadio.h"
 
// Device credentials, register device as OTAA in The Things Network and copy credentials here
static uint8_t DEV_EUI[] = { 0x26, 0x10, 0x20, 0x20, 0x11, 0x11, 0x20, 0x20 };
static uint8_t APP_EUI[] = { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x03, 0x74, 0x72 };
static uint8_t APP_KEY[] = { 0x75, 0x57, 0x56, 0x65, 0xB1, 0x8A, 0x17, 0x52, 0x1B, 0x2D, 0x45, 0xD9, 0xFC, 0x90, 0x9E, 0x05 };
 
// The port we're sending and receiving on
#define MBED_CONF_LORA_APP_PORT     15
 
// Peripherals (LoRa radio, temperature sensor and button)
SX1276_LoRaRadio radio(D11, D12, D13, D10, A0, D2, D3, D4, D5, D8, D9, NC, NC, NC, NC, A4, NC, NC);
static EventQueue ev_queue;
 
// Constructing Mbed LoRaWANInterface and passing it down the radio object.
static LoRaWANInterface lorawan(radio);
 
// Application specific callbacks
static lorawan_app_callbacks_t callbacks;
 
// LoRaWAN stack event handler
static void lora_event_handler(lorawan_event_t event);
 
static void send_message(int topicId, long int duration, string group) {
    uint8_t tx_buffer[50] = { 0 };
    
    string deviceId = "My Device";
    long int timestamp = 1234567892;
    int value = 2;
      sprintf((char*) tx_buffer, "{\"deviceId\":\"%s\",\"TopicId\":%d,\"Group\":%s}}", deviceId.c_str(), topicId, group.c_str());
    // Sending strings over LoRaWAN is not recommended
   // sprintf((char*) tx_buffer, "{\"topicId\":%d, \"duration\":%ld,\"group\":\"%s\"}", topicId, duration, group.c_str());
    int packet_len = strlen((char*) tx_buffer);
    printf("Sending %d bytes: \"%s\"\n", packet_len, tx_buffer);
    int16_t retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, tx_buffer, packet_len, MSG_UNCONFIRMED_FLAG);
    // for some reason send() returns -1... I cannot find out why, the stack returns the right number. I feel that this is some weird Emscripten quirk
    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? printf("send - duty cycle violation\n")
                : printf("send() - Error code %d\n", retcode);
          return;
    }
   
    printf("%d bytes scheduled for transmission\n", retcode);
     callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);
}
 
int initialize_lora() {
    if (DEV_EUI[0] == 0x0 && DEV_EUI[1] == 0x0 && DEV_EUI[2] == 0x0 && DEV_EUI[3] == 0x0 && DEV_EUI[4] == 0x0 && DEV_EUI[5] == 0x0 && DEV_EUI[6] == 0x0 && DEV_EUI[7] == 0x0) {
        printf("Set your LoRaWAN credentials first!\n");
        return -1;
    }
    printf("Initializing LORA!\n");
    // Enable trace output for this demo, so we can see what the LoRaWAN stack does
    mbed_trace_init();
    if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        printf("LoRa initialization failed!\n");
        return -1;
    }  
        // prepare application callbacks
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);
    // Disable adaptive data rating
    if (lorawan.disable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        printf("disable_adaptive_datarate failed!\n");
        return -1;
    }
    lorawan.set_datarate(5); // SF7BW125
    lorawan_connect_t connect_params;
    connect_params.connect_type = LORAWAN_CONNECTION_OTAA;
    connect_params.connection_u.otaa.dev_eui = DEV_EUI;
    connect_params.connection_u.otaa.app_eui = APP_EUI;
    connect_params.connection_u.otaa.app_key = APP_KEY;
    connect_params.connection_u.otaa.nb_trials = 3;
 
    lorawan_status_t retcode = lorawan.connect(connect_params);
 
    if (retcode == LORAWAN_STATUS_OK ||
        retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    } else {
        printf("Connection error, code = %d\n", retcode);
        return -1;
    }
 
    printf("Connection - In Progress ...\r\n");
    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();
    return 0;
}
 
 
 
//declare lcd
C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11); 
 
//humidity and temperature sensor
Sht31 sht31(I2C_SDA, I2C_SCL);
 
//declare components
//InterruptIn pushButton(BUTTON1); //p11
InterruptIn pushButton(p11);
DigitalOut whiteLed(p8);
DigitalOut redLed(p9);
DigitalOut blueLed(p10);
DigitalOut led2(LED2);
 
void State1();
void State2();
void Mode1();
void Mode2();
void CheckDirection();
void PrintContent();
void StartButtonTimer();
void StopButtonTimer();
void DurationCheck();
void NextTopic();
 
//topics and content
string content[5][2]= {{"Topic 1","Content 1"},{"Topic 2","Content 2"},{"Topic 3","Content 3"},{"Topic 4","Content 4"},{"Topic 5","Content 5"}};
string companyName = "Godfrey&SonsTech";
 

int direction = 0; // Forward is 0 False and Reverse 1true
int current_topic = 0;;
time_t loraTimerStart;
time_t loraTimerStop;
time_t buttonTimerStart;
time_t buttonTimerStop;
int loraDuration = 0;
int buttonDuration = 0;
Ticker flipper;
 
 
void PrintTemperatureAndTime() {
        
        time_t seconds = time(NULL);
        
        float temp = sht31.readTemperature();
        float humidity = sht31.readHumidity();
        lcd.locate(3, 3);
        lcd.printf("Temperature: %.2f C", temp);
    
        lcd.locate(3, 13);
        lcd.printf("Date/Time: %s", ctime(&seconds));
        // turn on LED if the temperature is above 25 degrees
    }
    
void WelcomeMessage(string companyName){
    lcd.cls();
    lcd.locate(3, 3);
    lcd.printf("Welcome");
    lcd.locate(3, 13);
    lcd.printf(companyName.c_str());
    wait(5);
    lcd.cls();
    
    //call Mode1
      Mode1();
    
}
// create an instance of LCD
void Display(string lcdPrint) {
    lcd.cls();  // Clear LCD
    lcd.locate(3,5); // get cursor to position x=3px and y=5px
    lcd.printf(lcdPrint.c_str()); // Write text into LCD buffer
    // Clear LCD
}

 
void StartButtonTimer(){
    printf("Button Timer start \n");
    buttonTimerStart = time(NULL);
    printf("Button timer start: %ld \n",buttonTimerStart);
    wait(0.5);
    
  
}
 
void StopButtonTimer(){
    printf("Button timer stop \n");
    loraTimerStop =time(NULL); 
    buttonTimerStop = time(NULL);
    printf("Button timer stop: %ld \n",buttonTimerStop);
    wait(0.5);
    
    loraDuration = loraTimerStop - loraTimerStart;
    
    buttonDuration = buttonTimerStop - buttonTimerStart;
    printf("Duration Lora: %d \n", loraDuration); 
    printf("Duration Button: %d \n", buttonDuration); 
    
    DurationCheck();
   
}
 
void NextTopic(){
    if(direction == 0){
        if(current_topic == 4){
           current_topic = -1; 
        }
        current_topic++;
    }
    
    if(direction ==1){
        if(current_topic == 0){
            current_topic = 5;
        }
        current_topic --;
    }
    
  CheckDirection();
}
 
void DurationCheck(){
    printf("duration check details: \n");
    printf("Duration Lora: %d \n", loraDuration); 
    printf("Duration Button: %d \n", buttonDuration); 
    
    if(loraDuration> 5) {
        //add lora sending function
        printf("Id: %d, duration: %d \n", current_topic, loraDuration );
        send_message(current_topic, loraDuration, "Grp2");
    }
    
    if(buttonDuration < 3)
    {
        //call next topic
        NextTopic();
    }
    
    if(buttonDuration >= 3 && buttonDuration <= 5){
        direction = !direction; 
        NextTopic();
    }
    
    if(buttonDuration > 5){
        Display("Reset to factory ....");
        wait(10);
        WelcomeMessage(companyName);
        
    }
    
}
 
 
void State1(){
    current_topic = 0;
    PrintTemperatureAndTime();
    wait(3);
    State2();
}
 
void State2(){
    printf("state 2 .. \n");
    
    while(current_topic< 5){
        printf("current topic %d \n", current_topic);
        Display(content[current_topic][0]);
        wait(2);
        current_topic ++;
    }
 
    State1();
}
 
void PrintContent(){
    
    Display(content[current_topic][1]);

}
 
void CheckDirection(){
    
    
    pushButton.rise(callback(&StartButtonTimer)); 
    pushButton.fall(callback(&StopButtonTimer));
    
    loraTimerStart = time(NULL);
    while(1) {
   
    
    if(direction == 0) //O is a forward direction
    {
        redLed = 0;
        blueLed = 1;
        PrintContent();
    }
    
    if(direction == 1) //O is a forward direction
    {
        redLed = 1;
        blueLed = 0;
        PrintContent();
    }
    
    wait_ms(200);
    }
}
 
void BlinkWhiteLed() {
    
    whiteLed = !whiteLed;
    led2 = !led2;
    
    
}
 
void Mode1(){
    
        printf("Mode 1... \n");
        printf("current topic %s \n", content[current_topic][0].c_str());
        blueLed = 0;
        redLed = 0; 
        
        flipper.attach(&BlinkWhiteLed, 1.0); 
        pushButton.fall(callback(&Mode2));
        
        State1();
}
 
void Mode2(){
  
    printf("Mode 2... \n");
    printf("current topic %s \n", content[current_topic][0].c_str());
    flipper.detach();
    whiteLed = 0;
    
    lcd.cls();
    wait_ms(500);
    CheckDirection();
 
    
}
 
int main() {

        Display("Initializing ..............");
        initialize_lora();
        WelcomeMessage(companyName);
  
}
 
// Event handler
static void lora_event_handler(lorawan_event_t event) {
    switch (event) {
        case CONNECTED:
            printf("Connection - Successful\n");
            ev_queue.break_dispatch();
            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("Disconnected Successfully\n");
            break;
        case TX_DONE:
            printf("Message Sent to Network Server\n");
            ev_queue.break_dispatch();
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            ev_queue.break_dispatch();
            printf("Transmission Error - EventCode = %d\n", event);
            break;
        case JOIN_FAILURE:
            printf("OTAA Failed - Check Keys\n");
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}