#ifndef _FILE_FANPUMP_H
#define _FILE_FANPUMP_H

#include "mbed.h"
#include "rtos.h"
#include "CANBuffer.h"

typedef enum {
    Pump = 0,
    Fan1 = 1,
    Fan2 = 2,
    Fan3 = 3,
} FanSelect;

typedef struct{
    unsigned char cur_duty;
    unsigned char new_duty;
    PwmOut *pin;    
} PinStatus;

const int PIN_NUM = 4;
const int TX_FAN_ID = ((4 << 8) | 4);
const int RX_FAN_ID = ((4 << 8) | 12);

class FanPump{
public:
    FanPump(CANBuffer *can);
    void set_fan(FanSelect fan, unsigned char duty);
    void shutdown(FanSelect fan);
    void shutdown_all();
    void start_update();
    
private:
    Thread *pin_threads[PIN_NUM];
    void free_pin(FanSelect fan);
};
#endif