#include "mbed.h"
#include "DC_DC.h"

DigitalOut dc_pin(p20);
FanPump *fanPump;
CANBuffer *tx_DC_Buffer;
bool status;

DC::DC(FanPump *fp, CANBuffer *can){
    status = false;
    dc_pin = !status;
    tx_DC_Buffer = can;
    fanPump = fp;
}

bool DC::is_on(){
    return status;
}

void DC::set(bool s){
    status = s;
    if(!status){
        fanPump->shutdown_all();    
    }
    
    dc_pin = !status;
}

void update(const void *arg){
    char data[4] = {0};
    while(1){
        data[0] = status;
        CANMessage txMessage(TX_DC_DC_ID, data, 4);
        CANMessage msg(1);
        tx_DC_Buffer->txWrite(msg);
        
        Thread::wait(100);          //10 Hz update
    }
}

void DC::start_update(){
    Thread update_thread(update);
}