#include "PollSwitch.h"

LPC_pin PollPin[12]={p1_0, p1_1, p1_4, p1_8, p1_9, p1_10, p1_14, p1_15, p1_16, p1_17, p1_27, p1_28};
LPCDigitalOut poll[12]={    LPCDigitalOut(PollPin[0]),
                            LPCDigitalOut(PollPin[1]),
                            LPCDigitalOut(PollPin[2]),
                            LPCDigitalOut(PollPin[3]),
                            LPCDigitalOut(PollPin[4]),
                            LPCDigitalOut(PollPin[5]),
                            LPCDigitalOut(PollPin[6]),
                            LPCDigitalOut(PollPin[7]),
                            LPCDigitalOut(PollPin[8]),
                            LPCDigitalOut(PollPin[9]),
                            LPCDigitalOut(PollPin[10]),
                            LPCDigitalOut(PollPin[11])};
 
CANBuffer *tx_Poll_Buffer;

union int_to_char {
    char ch[2];
    uint16_t i;                       
} converter;
                       
PollSwitch::PollSwitch(CANBuffer *can){
    tx_Poll_Buffer = can;
    for(int i = 0; i < 12; i++){
        poll[i].mode(PullDown);    
    }
}

uint16_t poll_switches(){
    uint16_t a = 0;
    int i = 0;
    
    // if a low signal is detected, previous switch is broken
    for(i = 1; i < 12; i++){
        if(!poll[i].read())
            break;
    }
    
    // bit on: switch may be broken
    a = 0 & (0xFF >> (i-1));
    return a;
}

void update_poll(const void *arg){
    char data[4] = {0};
    while(1){
        converter.i = poll_switches();
        data[0] = converter.ch[0];
        data[1] = converter.ch[1];
        CANMessage txMessage(TX_POLL_ID, data, 4);
        tx_Poll_Buffer->txWrite(txMessage);
        
        Thread::wait(100);      //10 Hz update
    }
}

void PollSwitch::start_update(){
    Thread update_thread(update_poll);   
}