/*
Test Code
#include "mbed.h"
#include "TemperatureRead.h"

AnalogIn Vin(p15);
int main()
{
    float resistance,temperature,Vadc=0;
    while(1)
    {
        Vadc=Vin.read()*VDD;
        //printf("Vadc:%f\n\r",Vadc);
        while(Vadc>0)
        {
            Vadc=Vin.read()*VDD;
            printf("Vadc:%f\n\r",Vadc);
            resistance=((float)R10K*Vadc)/((float)VDD + Vadc);
            temperature=ReadTemp(TR_USP10982_Map, resistance, TABLE_SIZE_USP10982);
            printf("Resistance:%f \n\r",resistance);
            printf("Temperature:%f \n\r",temperature);
            wait(0.5);
        }   
    }
}    
*/
#ifndef _TEMPERATURE_READ_
#define _TEMPERATURE_READ_

#define TABLE_SIZE_NXFT15XH103FA 34
#define TABLE_SIZE_NTCLP00E3103H 26
#define TABLE_SIZE_USP10982 121  
#define R10K 10                        //Consider Resistance in Kohms
#define VDD 3.33
typedef struct 
{
    float x;
    float y;
}Temp_Resistance;

Temp_Resistance TR_NXFT15XH103FA_Map[TABLE_SIZE_NXFT15XH103FA] ={
    { .x=   197.388 , .y=   -40 },
    { .x=   149.395 , .y=   -35 },
    { .x=   114.345 , .y=   -30 },
    { .x=   88.381  , .y=   -25 },
    { .x=   68.915  , .y=   -20 },
    { .x=   54.166  , .y=   -15 },
    { .x=   42.889  , .y=   -10 },
    { .x=   34.196  , .y=   -5  },
    { .x=   27.445  , .y=   0   },
    { .x=   22.165  , .y=   5   },
    { .x=   18.01   , .y=   10  },
    { .x=   14.72   , .y=   15  },
    { .x=   12.099  , .y=   20  },
    { .x=   10      , .y=   25  },
    { .x=   8.309   , .y=   30  },
    { .x=   6.939   , .y=   35  },
    { .x=   5.824   , .y=   40  },
    { .x=   4.911   , .y=   45  },
    { .x=   4.16    , .y=   50  },
    { .x=   3.539   , .y=   55  },
    { .x=   3.024   , .y=   60  },
    { .x=   2.593   , .y=   65  },
    { .x=   2.233   , .y=   70  },
    { .x=   1.929   , .y=   75  },
    { .x=   1.673   , .y=   80  },
    { .x=   1.455   , .y=   85  },
    { .x=   1.27    , .y=   90  },
    { .x=   1.112   , .y=   95  },
    { .x=   0.976   , .y=   100 },
    { .x=   0.86    , .y=   105 },
    { .x=   0.759   , .y=   110 },
    { .x=   0.673   , .y=   115 },
    { .x=   0.598   , .y=   120 },
    { .x=   0.532   , .y=   125 },
    };
    
Temp_Resistance TR_NTCLP00E3103H_Map[TABLE_SIZE_NTCLP00E3103H] ={
    { .x=   332.094 , .y=   -40 },
    { .x=   239.9   , .y=   -35 },
    { .x=   175.2   , .y=   -30 },
    { .x=   129.287 , .y=   -25 },
    { .x=   96.358  , .y=   -20 },
    { .x=   72.5    , .y=   -15 },
    { .x=   55.046  , .y=   -10 },
    { .x=   42.157  , .y=   -5  },
    { .x=   32.554  , .y=   0   },
    { .x=   25.339  , .y=   5   },
    { .x=   19.872  , .y=   10  },
    { .x=   15.698  , .y=   15  },
    { .x=   12.488  , .y=   20  },
    { .x=   10      , .y=   25  },
    { .x=   8.059   , .y=   30  },
    { .x=   6.535   , .y=   35  },
    { .x=   5.33    , .y=   40  },
    { .x=   4.372   , .y=   45  },
    { .x=   3.605   , .y=   50  },
    { .x=   2.989   , .y=   55  },
    { .x=   2.49    , .y=   60  },
    { .x=   2.084   , .y=   65  },
    { .x=   1.753   , .y=   70  },
    { .x=   1.481   , .y=   75  },
    { .x=   1.256   , .y=   80  },
    { .x=   1.07    , .y=   85  },

    };    
    
Temp_Resistance TR_USP10982_Map[TABLE_SIZE_USP10982] ={
    { .x=   336.479 , .y=   -40 },
    { .x=   314.904 , .y=   -39 },
    { .x=   294.848 , .y=   -38 },
    { .x=   276.194 , .y=   -37 },
    { .x=   258.838 , .y=   -36 },
    { .x=   242.681 , .y=   -35 },
    { .x=   227.632 , .y=   -34 },
    { .x=   213.61  , .y=   -33 },
    { .x=   200.539 , .y=   -32 },
    { .x=   188.349 , .y=   -31 },
    { .x=   176.974 , .y=   -30 },
    { .x=   166.356 , .y=   -29 },
    { .x=   156.441 , .y=   -28 },
    { .x=   147.177 , .y=   -27 },
    { .x=   138.518 , .y=   -26 },
    { .x=   130.421 , .y=   -25 },
    { .x=   122.847 , .y=   -24 },
    { .x=   115.759 , .y=   -23 },
    { .x=   109.122 , .y=   -22 },
    { .x=   102.906 , .y=   -21 },
    { .x=   97.081  , .y=   -20 },
    { .x=   91.621  , .y=   -19 },
    { .x=   86.501  , .y=   -18 },
    { .x=   81.698  , .y=   -17 },
    { .x=   77.19   , .y=   -16 },
    { .x=   72.957  , .y=   -15 },
    { .x=   68.982  , .y=   -14 },
    { .x=   65.246  , .y=   -13 },
    { .x=   61.736  , .y=   -12 },
    { .x=   58.434  , .y=   -11 },
    { .x=   55.329  , .y=   -10 },
    { .x=   52.407  , .y=   -9  },
    { .x=   49.656  , .y=   -8  },
    { .x=   47.066  , .y=   -7  },
    { .x=   44.626  , .y=   -6  },
    { .x=   42.327  , .y=   -5  },
    { .x=   40.159  , .y=   -4  },
    { .x=   38.115  , .y=   -3  },
    { .x=   36.187  , .y=   -2  },
    { .x=   34.368  , .y=   -1  },
    { .x=   32.65   , .y=   0   },
    { .x=   31.029  , .y=   1   },
    { .x=   29.498  , .y=   2   },
    { .x=   28.052  , .y=   3   },
    { .x=   26.685  , .y=   4   },
    { .x=   25.392  , .y=   5   },
    { .x=   24.17   , .y=   6   },
    { .x=   23.013  , .y=   7   },
    { .x=   21.918  , .y=   8   },
    { .x=   20.882  , .y=   9   },
    { .x=   19.901  , .y=   10  },
    { .x=   18.971  , .y=   11  },
    { .x=   18.09   , .y=   12  },
    { .x=   17.255  , .y=   13  },
    { .x=   16.463  , .y=   14  },
    { .x=   15.712  , .y=   15  },
    { .x=   14.999  , .y=   16  },
    { .x=   14.323  , .y=   17  },
    { .x=   13.681  , .y=   18  },
    { .x=   13.072  , .y=   19  },
    { .x=   12.493  , .y=   20  },
    { .x=   11.942  , .y=   21  },
    { .x=   11.419  , .y=   22  },
    { .x=   10.922  , .y=   23  },
    { .x=   10.45   , .y=   24  },
    { .x=   10      , .y=   25  },
    { .x=   9.572   , .y=   26  },
    { .x=   9.165   , .y=   27  },
    { .x=   8.777   , .y=   28  },
    { .x=   8.408   , .y=   29  },
    { .x=   8.057   , .y=   30  },
    { .x=   7.722   , .y=   31  },
    { .x=   7.402   , .y=   32  },
    { .x=   7.098   , .y=   33  },
    { .x=   6.808   , .y=   34  },
    { .x=   6.531   , .y=   35  },
    { .x=   6.267   , .y=   36  },
    { .x=   6.015   , .y=   37  },
    { .x=   5.775   , .y=   38  },
    { .x=   5.545   , .y=   39  },
    { .x=   5.326   , .y=   40  },
    { .x=   5.117   , .y=   41  },
    { .x=   4.917   , .y=   42  },
    { .x=   4.725   , .y=   43  },
    { .x=   4.543   , .y=   44  },
    { .x=   4.368   , .y=   45  },
    { .x=   4.201   , .y=   46  },
    { .x=   4.041   , .y=   47  },
    { .x=   3.888   , .y=   48  },
    { .x=   3.742   , .y=   49  },
    { .x=   3.602   , .y=   50  },
    { .x=   3.468   , .y=   51  },
    { .x=   3.34    , .y=   52  },
    { .x=   3.217   , .y=   53  },
    { .x=   3.099   , .y=   54  },
    { .x=   2.986   , .y=   55  },
    { .x=   2.878   , .y=   56  },
    { .x=   2.774   , .y=   57  },
    { .x=   2.675   , .y=   58  },
    { .x=   2.579   , .y=   59  },
    { .x=   2.488   , .y=   60  },
    { .x=   2.4     , .y=   61  },
    { .x=   2.316   , .y=   62  },
    { .x=   2.235   , .y=   63  },
    { .x=   2.157   , .y=   64  },
    { .x=   2.083   , .y=   65  },
    { .x=   2.011   , .y=   66  },
    { .x=   1.942   , .y=   67  },
    { .x=   1.876   , .y=   68  },
    { .x=   1.813   , .y=   69  },
    { .x=   1.752   , .y=   70  },
    { .x=   1.693   , .y=   71  },
    { .x=   1.637   , .y=   72  },
    { .x=   1.582   , .y=   73  },
    { .x=   1.53    , .y=   74  },
    { .x=   1.48    , .y=   75  },
    { .x=   1.432   , .y=   76  },
    { .x=   1.385   , .y=   77  },
    { .x=   1.34    , .y=   78  },
    { .x=   1.297   , .y=   79  },
    { .x=   1.255   , .y=   80  },
    };
        
float ReadTemp(const Temp_Resistance *table, float value, size_t SIZE)
{
    //Search using Binary Search. Logarithmic passes
    int result=SIZE, slope=0;
    size_t firstPos=0;
    size_t lastPos=SIZE;
    size_t middlePos=0;
    size_t temp_mid=1;
    //printf("Value:%f\n\r",value);
    while(temp_mid!=middlePos)
    {
        temp_mid=middlePos;
        middlePos = firstPos + (lastPos-firstPos)/2;
        if(table[middlePos].x == value)
        {
            lastPos = middlePos;
            result = middlePos;
        }
        
        if(table[middlePos].x < value) 
        {
            lastPos = middlePos;
            result = middlePos;         
        }
        
        else if(table[middlePos].x > value)
        {
            firstPos = middlePos;
        }
    }
    //printf("Result:%d\n\r",result);
    if(result == 0)
        return  table[result].y;
    else if(result == SIZE)
        return  table[result - 1].y;
    
    slope = (table[result].y - table[result-1].y)/(table[result].x - table[result-1].x);
    return (slope*(value - table[result].x) + table[result].y);          
}
#endif /*_TEMPERATURE_READ_*/   