/*  Test Code
    #include "Battery_Status.h"
    #include"mbed.h"   
    BatteryStatus battery;
    
    int main()
    {
        //battery.write(6.92,0);
        printf("LPC_RTC->GPREG0:%f\n\r",battery.read(0));
        //battery.write(7.92,1);
        printf("LPC_RTC->GPREG1:%f\n\r",battery.read(1));
        //battery.write(8.92,2);
        printf("LPC_RTC->GPREG2:%f\n\r",battery.read(2));
        //battery.write(9.92,3);
        printf("LPC_RTC->GPREG3:%f\n\r",battery.read(3));
        //battery.write(10.92,4);
        printf("LPC_RTC->GPREG4:%f\n\r",battery.read(4));
    }
*/        

#ifndef _BATTERY_STATUS_
#define _BATTERY_STATUS_
#include"mbed.h"

// General purpose register 0
#define _GPREG_BASE 0x40024044

// RTC = Real-Time Clock

class RTCStore
{
    public:
      RTCStore()
      {
          LPC_SC->PCONP |= (1<<9);        //Enable RTC Peripheral
      }
      
      void write(float data, int block)
      {
         *(uint32_t*)(_GPREG_BASE + (0x04*block)) = *((uint32_t*)&data);
         //LPC_RTC->GPREG0 = *((uint32_t*)&data);
      }
      
      float read(int block)
      {
          return *((float*)(uint32_t*)(_GPREG_BASE + (0x04*block)));
          //return *((float*)&(LPC_RTC->GPREG0));
      }              
};
#endif /* _BATTERY_STATUS_ */
    