#include "mbed.h"
#include "string.h"
/*
#include "Get_IMD.h"
DigitalOut myled(LED1);

int main() 
{
    IMD_Measurement_Output IMD_Result;
    while(1) 
    {
        IMD_Result=Get_Measurement();
        pc.printf("Frequency:%f\n\r",IMD_Result.Frequency);
        pc.printf("Duty Cycle:%f\n\r",IMD_Result.Duty_Cycle);
        pc.printf("State:%s\n\n\r",IMD_Result.State);
    }
}
*/

//Serial pc(USBTX,USBRX);

#ifndef GET_IMD_H
    #define GET_IMD_H  
    typedef struct
    {
        float Frequency;
        float Duty_Cycle;
        char State[50];
        char Encoded_Status;
    }IMD_Measurement_Output;
    
    bool FirstFE=true;
    bool FirstRE=true;
    uint32_t ON_Period =0;
    uint32_t INT0_RE,INT0_FE;
    uint32_t CAP0RE=0, CAP0FE=1, CRO_I=4;
    IMD_Measurement_Output Result;
    
    extern "C" void TIMER0_IRQHandler(void)
    {
        INT0_RE=LPC_TIM0->CCR;
        INT0_FE=LPC_TIM0->CCR;
        
        
        if(((INT0_FE & (1 << CAP0FE)) >> CAP0FE))
        {
            if(!FirstFE)
            {
                //pc.printf("LPC_TIM1->TC in FE:%d\n\r",LPC_TIM1->TC);                
                ON_Period = LPC_TIM1->TC;
                //pc.printf("On Period:%d\n\r",ON_Period);
                LPC_TIM0->CCR   |=  ((1<<0) | (1<<2));      //Copy TC to CRO on Rising Edge AND Generate Interrupt                
                LPC_TIM0->CCR   &=  ~(1<<1);     //Disable Falling Edge
            }
            else
                FirstFE=false;                            
        }
        else if((INT0_RE & (1 << CAP0RE))>> CAP0RE)
        {
            //pc.printf("On Period In RE:%d\n\r",ON_Period);
            if(!FirstRE)
            {
                //pc.printf("LPC_TIM1->TC in RE:%d\n\r",LPC_TIM1->TC);
                //pc.printf("On Period In RE:%d\n\r",ON_Period);
                Result.Frequency=((1/(float)LPC_TIM1->TC)*1000);
                Result.Duty_Cycle=((ON_Period/(float)LPC_TIM1->TC)*100);
                LPC_TIM0->CCR   |=  ((1<<1) | (1<<2));      //Copy TC to CRO on Falling Edge AND Generate Interrupt                             
                LPC_TIM0->CCR   &=  ~(1<<0);                //Disable Rising Edge
                LPC_TIM1->TCR   |=  (1<<1);                 //Reset Timer1
                LPC_TIM1->TCR   &=  ~(1<<1);                 //Restart Timer1
            }
            else
                FirstRE=false;    
        }
        LPC_TIM0->IR |= (1<<CRO_I);                         //Reset Counter0 Interrupt
        return;  
    }
    
    void init()
    {
        Result.Frequency=0;
        Result.Duty_Cycle=0;
        strcpy(Result.State,"");
        //Set pin as capture mode
        //Initialize Counter2
        LPC_PINCON->PINSEL3 |=  ((1<<21) | (1<<20));          //Set Pin1.26 as CAP0.0 
        LPC_SC->PCONP       |=  (1<<1);                    //PowerOn Timer/Counter0.
        LPC_TIM0->CCR       |=  ((1<<1) | (1<<2));          //Copy TC to CRO on Falling Edge AND Generate Interrupt
        NVIC_SetPriority(TIMER0_IRQn,255);
        NVIC_EnableIRQ(TIMER0_IRQn);                        //Enable TIMER0 IRQ      
        
        //Initiallize Timer1
        LPC_SC->PCONP       |=  (1<<2);                     //PoewerOn Timer/Counter1
        LPC_SC->PCLKSEL0    |=  ((1<<4) | (1<<5));          //Prescale Timer1 CCLK/8  
        LPC_TIM1->CTCR      &=  ~((1<<1) | (1<<0));         //Set Timer/Counter1 as as Timer mode
        LPC_TIM1->PR        =   11985;                      //Timeout every 1msec(Timer Resolution)
        LPC_TIM1->TCR       |=  (1<<1);                     //Reset Timer1
        LPC_TIM1->TCR       |=  (1<<0);                     //Enable Timer1
        //LPC_TIM1->TCR       &=  ~(1<<1);                 //Restart Timer1              
        FirstRE=false;
        FirstFE=false;
    }    
    
    void Disable()
    {
        LPC_TIM1->TCR   |=  (1<<1);                     //Reset Timer1
        LPC_TIM0->IR    |=  (1<<4);                     //Reset Counter0 Interrupt
        NVIC_DisableIRQ(TIMER0_IRQn);
    }
    
    IMD_Measurement_Output Get_Measurement()
    {
        init();
        wait_ms(300);
        Disable();
        if(Result.Frequency >=5 && Result.Frequency <15){
                strcpy(Result.State, "Normal condition");
                Result.Encoded_Status='1';
            }
        else if(Result.Frequency >=15 && Result.Frequency <25){
                strcpy(Result.State, "underVoltage condition");
                Result.Encoded_Status='2';
            }
        else if(Result.Frequency >=25 && Result.Frequency <35)
                {
                    if(Result.Duty_Cycle <=15){
                        strcpy(Result.State, "Insulation measurement:good");
                        Result.Encoded_Status='3';
                    }
                    else if(Result.Duty_Cycle > 85 && Result.Duty_Cycle < 100){
                        strcpy(Result.State, "Insulation measurement:bad");
                        Result.Encoded_Status='4';
                    }    
                }
        else if(Result.Frequency >=35 && Result.Frequency <45){
                strcpy(Result.State, "Device error");
                Result.Encoded_Status='5';
            }
        else if(Result.Frequency >=45 && Result.Frequency <55){
                strcpy(Result.State, "Connection fault earth");    
                Result.Encoded_Status='6';
            }                                            
        return Result; 
    }
    
    #endif/* GET_IMD_H */