/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include "MicroBit.h"

MicroBit uBit;

const char Answers[9][27] = {"It is certain;", "It is decidedly so;",  "Cannot predict now;", 
                             "Concentrate and ask again;", "Don't count on it;",  "My reply is no;", 
                             "My sources say no;", "Outlook not so good;", "Very doubtful;"};
//
//
//
int checkForShake() {
     uint32_t accVal = 0;
     int x = (uBit.accelerometer.getX());
     int y = (uBit.accelerometer.getY());
     accVal = (abs(x) + abs(y));  
     return accVal;
}
//
//
int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    uBit.seedRandom(); 
   while(1) {
     uBit.display.print('8');
     if (checkForShake() >= 2500) {                //   (uBit.accelerometer.getGesture()== SHAKE)
       char response[27] = ""; 
       int idx1 = uBit.random(9);
       int idx2 = 0;
       while(Answers[idx1][idx2] != ';')           //   terminates on ;
          {
          response[idx2] = Answers[idx1][idx2];
          idx2++;
          }
        uBit.display.scroll(response);
        uBit.sleep(1000);}}
}
//