/* 
read string via rs232 and switch blue leds ...
*/
#include "mbed.h"

#define rgbOFF 7
#define rgbRED 6
#define rgbBLUE 3
#define rgbYELLOW 4
// global vars and objects
BusOut blueLeds(LED1, LED2, LED3, LED4);
BusOut rgbLeds(p23, p24, p25);

// functions

int main() {
    int8_t cnt=0;      // count var
    uint8_t countDirection = ' ';  // Eingabevariable von der seriellen Schnittstelle
    int upCycles = 0, downCycles = 0;
    rgbLeds.write(rgbOFF);
    printf("mbed Uebung C - Bulme: Count Up and Down/SC\r\n");
    
    while(1) {
        rgbLeds = rgbYELLOW;
        printf("\r\nZaehlrichtung auswaehlen: u --> aufwaerts zaehlen, d --> abwaehrts zaehlen;\r\nBitte um Eingabe: ");
        countDirection = getchar();
        printf("Zaehlrichtung = %c", countDirection);
        if (countDirection == 'u') {
            rgbLeds = rgbBLUE;
            printf("\r\nCount UP: Aufwaertszaehlzyklus = %d\r\n", ++upCycles);
            for (cnt=0; cnt<=15; cnt++) {
                printf("Zaehlerstand = %d\r\n", cnt); 
                blueLeds = cnt; 
                wait(0.5);        
            }
        }
        else if (countDirection == 'd')  {
            downCycles++; 
            rgbLeds = rgbRED;        
            printf("\r\nCount DOWN: Abwaertszaehlzyklus = %d\r\n", downCycles);
            for (cnt=15; cnt>=0; cnt--) {
                printf("Zaehlerstand = %d\r\n", cnt);
                blueLeds.write(cnt);   
                wait(0.5);        
            }
        }
        else
            printf("\r\nmbed Uebung C: keine gueltige Eingabe fuer die Zaehlrichtung!\r\n");            
    }
}

