#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11); // LCD mit 128 x 32 Pixel
AnalogIn aiPoti1(p19);

int main() {
    float poti1Wert;
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-127; y: 0-31)
    lcd.printf("Wert vom Poti 1:");
    while(1) {
        lcd.locate(0,10);
        poti1Wert = aiPoti1.read();
        lcd.printf("Spannung 1 = %5.3f V", poti1Wert*3.3);
		// Balkengraph: linker oberer Punkt (Pixelnummer): x=0, y=20; 
		// rechter unterer Punkt: x=(int)(poti1Wert*127), y=28; letzter Parameter = 1 = schwarz
        lcd.fillrect(0, 20, (int)(poti1Wert*127), 28, 1);	 
		// Löschen des restlichen Bereichs bis zum Ende des Displays; ist notwendig, weil der aktuelle
		// Balken kann ja auch kürzer sein als der zuvor geschriebene Balken!
        lcd.fillrect((int)(poti1Wert*127)+1, 20, 127, 28, 0);  // 0 = transparent (Hintergrundfarbe)
        lcd.copy_to_lcd();	// erzwingt sofortiges Anzeigen am LCD
        wait_ms(100);
    }
}
