// Beispiel Mittelwerte
// Peter Beck - 16.04.2018

#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn aiPoti1(p19);

DigitalIn diDown(p12);
DigitalIn diUp(p15);
InterruptIn iiDown(p12);
InterruptIn iiUp(p15);

//AnalogIn aiPoti2(p20);
Timeout BlinkTimeoutTmr;

Ticker toreadPoti1;

float poti1Wert;
float poti1Durchschnitt;
float poti1Array[10];

int slot = 0;
int mode = 0; //Messmodus
BusOut doLeds(LED1,LED2,LED3,LED4);


// functions

void BlinkTimeout()
{
    doLeds = 0;
}

void readPoti1()
{
    // Poti-Wert auslesen
    poti1Wert = 3.3 * aiPoti1.read();

    poti1Array[slot] = poti1Wert;

    slot++;
    if (slot>9) slot = 0;

    // Ausgabe:


    poti1Durchschnitt = 0;
    for (int i=0; i<10; i++) {
        poti1Durchschnitt += poti1Array[slot];
    }
    poti1Durchschnitt /= 10;

    lcd.locate(0,0);
    lcd.printf("Spannung aktuell = %5.3f V", poti1Wert); // Schreibe..
    lcd.locate(0,10); // Setze Cursor auf X=0, Y=10

    lcd.printf("Spannung gerundet = %5.3f V", poti1Durchschnitt); // Schreibe..
    lcd.fillrect(0, 20, (int)(poti1Wert*128/3.3), 24, 1);  // Schreibe Block mit X=0,Y=20, X2=(errechnet), Y2=28 in der Farbe 1
    lcd.fillrect(0, 25, (int)(poti1Durchschnitt*128/3.3), 28, 1);  // Schreibe Block mit X=0,Y=20, X2=(errechnet), Y2=28 in der Farbe 1

    lcd.fillrect((int)(poti1Durchschnitt*128/3.3), 20, 128, 28, 0); // Schreibe eine weissen Block auf der restlichen Fläche in der Farbe 1
    lcd.copy_to_lcd();

}



int main()
{
    
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,10); // Setze Cursor auf X=0, Y=10
    lcd.printf("Willkommen!");
    lcd.copy_to_lcd();
    wait_ms(300);

    // Erstellung von 2 Arrays für die gleitende Mittelwertbildung
    // 2 Hz mit Ticker realisieren
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("Werte von Poti 1 und 2:");

    toreadPoti1.attach(&readPoti1, 0.5);


    while(1) {

    }
}


