/*#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn aiPoti1(p19);
AnalogIn aiPoti2(p20);

int main() {
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    //lcd.printf("Werte von Poti 1 und 2:");
    while(1) {
        lcd.locate(0,10);
        lcd.printf("Rohwert 1 = : %i", aiPoti1.read()*1024);
        lcd.locate(0,20);
        lcd.printf("Spannung 2 = : %f V", aiPoti2.read()*3.3);
        wait_ms(500);
    }
}
*/
// Beispiel GRENZWERTE
// Peter Beck - 16.04.2018

#include "mbed.h"
#include "C12832.h"

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// RGBLED-Klasse

class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};

RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}

void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}

//Setup RGB led using PWM pins and class
RGBLed myRGBled(p23,p24,p25); //RGB PWM pins

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------

C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn aiPoti1(p19);
//AnalogIn aiPoti2(p20);


DigitalIn diDown(p12);
DigitalIn diUp(p15);
InterruptIn iiDown(p12);
InterruptIn iiUp(p15);

Timeout BlinkTimeoutTmr;
Timeout ClearMSGtimeout;
Ticker toreadPoti1;


int mode = 0; //Messmodus
BusOut doLeds(LED1,LED2,LED3,LED4);

int poti1Wert;
int Warngrenze = 800;
int Alarmgrenze = 950;

// -----------------------------------------------------------------------------

void BlinkTimeout()
{
    doLeds = 0;
}


void ClearMSG()
{
    // Leere die mittlere Zeile und schreibe den Standardtext weider aud den Sceen..
    lcd.locate(0,10);
    lcd.fillrect(0, 10, 128, 20, 0);
    lcd.locate(0,10); // Setze Cursor auf X=0, Y=10
    lcd.printf("W=%d A=%d",Warngrenze, Alarmgrenze);
    lcd.copy_to_lcd();
}



void readPoti1()
{
    // Poti-Wert auslesen
    poti1Wert = (int)(1023 * aiPoti1.read()); // Wert soll von 0-1023 gehen anstatt von 0-1

    lcd.locate(0,0);
    lcd.printf("%5.3f V / %d", ((float)(poti1Wert))*3.3/1023, poti1Wert); // Schreibe..
    lcd.copy_to_lcd();



    if (mode > 0) { // nur aktiv wenn nicht auf Standby

        if (poti1Wert >= Warngrenze && mode != 3) {
            mode=2; // Warnmodus
            myRGBled.write(0,0,1.0); //yellow

            lcd.cls();
            lcd.locate(0,10);
            lcd.printf("Warnung!");
            lcd.copy_to_lcd();
            ClearMSGtimeout.attach(&ClearMSG,3);

        }

        if (poti1Wert < Warngrenze && mode != 3) {
            mode=1;
            myRGBled.write(1,0,1); //green
            
        }
        if (poti1Wert >= Alarmgrenze) {
            mode=3; // Alarmmodus
            myRGBled.write(0,1,1); //red
            
            lcd.cls();
            lcd.locate(0,10);
            lcd.printf("ALARM!!!!");
            lcd.copy_to_lcd();
            ClearMSGtimeout.attach(&ClearMSG,3);



        }


    }


}

void swUp()
{
    // Starte Messung
    mode = 1;
    myRGBled.write(1,0,1); //green

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Mess. gestartet");
    lcd.copy_to_lcd();
}
void swDown()
{
    // Beende Messung
    mode = 0;
    myRGBled.write(1,1,1); //off
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,10); // Setze Cursor auf X=0, Y=10
    lcd.printf("W=%d A=%d",Warngrenze, Alarmgrenze );
    lcd.copy_to_lcd();
    wait_ms(400);

}

int main()
{

    myRGBled.write(1,1,1); //RGB-LED leeren

    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,10); // Setze Cursor auf X=0, Y=10
    lcd.printf("Willkommen!");
    lcd.copy_to_lcd();
    wait_ms(500);
    
    //myRGBled.write(0,1,1); //red
    //wait(0.3);
    //myRGBled.write(1,0,1); //green
    //wait(0.3);
    //myRGBled.write(1,1,0); //blue
    //wait(0.3);


    swDown(); // Rest and goto HOME
    toreadPoti1.attach(&readPoti1, 0.5);
    
    iiDown.rise(&swDown);
    iiUp.rise(&swUp);

    while(1) {

    }
    
}
