#include "mbed.h"
#include "Serial_HL.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

// V2.0
// BusOut leds(LED1,LED2,LED3,LED4); Bertl14
// M0-Board
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);


//RGB Leds:
PwmOut LR(p23);  //Klasse PwmOut Led Rot (Pin 23) Pulsweitenmodulation
PwmOut LG(p24);
PwmOut LB(p25);


void CommandHandler();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);// Muss gleich sein, wie in SvVis3
    leds = 9;


//PWM Periode = 1ms = 1kHz   Pulsweitenmodulation
    LR.period_ms(1);//Led Rot soll 1 Millisekunde leuchten
    LG.period_ms(1);
    LB.period_ms(1);
    
//    LR = 0.1; // 10% Pulsweite
//    LG = 0.1;
//    LB = 0.1;   oder
    
    LR = (1-0.1);// 10% für invertierte Logik
    LG = (1-0.1);
    LB = (1-0.1);

    ua0.SvMessage("ProcVisDemo_RGB_Led1"); // Meldung zum PC senden

    int16_t sv1=0, sv2=100; float sv3=0;
    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( ua0.acqON && (stw.read_ms()>100) ) { // 10Hz
            // dieser Teil wird mit 10Hz aufgerufen
            stw.reset();//Timer zurücksetzen
            sv1++;
            sv2++;
            sv3+=0.1;
            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde
                // wird auch etwas gesendet
                ua0.WriteSvI16(1, sv1);//Kanalnummer 1
                ua0.WriteSvI16(2, sv2);//Kanalnummer 2
                ua0.WriteSV(3, sv3);//Kanalnummer 3
            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;

    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;

    // Kommando lesen
    cmd = ua0.GetCommand();
    
    if(cmd == 2)// Eingabe in SvVis:    2 0,0 0,9 0,0     (cmd = 2, Gelb leuchtet)
    {
        LR = (1- ua0.ReadF());
        LG = (1- ua0.ReadF());
        LB = (1- ua0.ReadF());
        ua0.SvMessage("Setze RGB"); // Meldung an PC senden
    }

    if(cmd == 3)// Eingabe in SvVis:    2 0,9     (cmd = 3, Rot leuchtet)
    {
        LR = (1- ua0.ReadF());
        ua0.SvMessage("RGB_Rot "); // Meldung an PC senden
    }

    if(cmd == 4)
    {
        LG = (1- ua0.ReadF());
        ua0.SvMessage("RGB_Gelb "); // Meldung an PC senden
    }

    if(cmd == 5)
    {
        LB = (1- ua0.ReadF());
        ua0.SvMessage("RGB_Blau "); // Meldung an PC senden
    }


}


