#include "mbed.h"
#include "Serial_HL.h"
#include "MMA7660.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

// V2.0
// BusOut leds(LED1,LED2,LED3,LED4); Bertl14
// M0-Board
//BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
MMA7660 accel (p28, p27);


void CommandHandler();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);

    ua0.SvMessage("Accelerator Test"); // Meldung zum PC senden
    
    accel.setSampleRate(120);
    int val2[3];
    Timer stw;
    stw.start();
    
    while(1) {
        CommandHandler();
        if( ua0.acqON && (stw.read_ms()>100) )  // 10Hz
        {
            // dieser Teil wird mit 10Hz aufgerufen
            stw.reset();
            accel.readData(val2);//X,Y,Z vom PC lesen
            ua0.WriteSvI16(1, val2[0]);//X,Y,Z zum PC senden
            ua0.WriteSvI16(2, val2[1]);
            ua0.WriteSvI16(3, val2[2]);
        }
    return 1;
    }
}

void CommandHandler()
{
    uint8_t cmd;
    int16_t idata1, idata2;

    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;

    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

    if( cmd==2 ) {
        // cmd2 hat 2 int16 Parameter
        idata1 = ua0.ReadI16();
        idata2 = ua0.ReadI16();
        // für die Analyse den Wert einfach nur zum PC zurücksenden
        ua0.SvPrintf("Command2 %d %d", idata1, idata2);
    }   
    
    if( cmd==3 )  //leds schalten
    {
           
        ua0.SvMessage("SetLeds Awa pronto!");
    }
}


