
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15

//Funktionen
void ForewardUntilXing();
void NinetyDegreesLeft();
void CorrectToRight();
void CorrectToLeft();
bool CheckLeftSensor();
bool CheckLeftFrontSensor();
bool CheckRightSensor();
bool CheckRightFrontSensor();

//globale Variablen
int SensorLeft = 0;
int SensorFrontLeft = 0;
int SensorRight = 0;
int SensorFrontRight = 0;


int main(void)
{
    boardPow=3; wait_ms(10);
    InitBertl();
    pex.useISR=0; leds=9;
    pex.ClearLeds();
    
     
    while(1)
    {
        ForewardUntilXing();
        NinetyDegreesLeft();
    } 
}


void ForewardUntilXing()
{
    while (CheckLeftFrontSensor() != 1 && CheckLeftSensor() != 1)
    {
        mL.SetPow(0.3); mR.SetPow(0.3);//geradeaus
        if(/*SensorLeft (zu weit Links)*/)
        {
            CorrectToRight();
        }
        else if(/*SensorRight (zu weit Rechts)*/)
        {
            CorrectToLeft();
        }
    }
}


void NinetyDegreesLeft()
{
    for (int i = 0; i <= 10; i++)
    {
        mL.SetPow(0.3); mR.SetPow(0.1);//Linkskurve 
        wait_ms(100);
    }

}


bool CheckLeftSensor()
{
    if (SensorLeft > 0)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}



bool CheckLeftFrontSensor()
{
    if (SensorFrontLeft > 0)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


bool CheckRightSensor()
{
    if (SensorRight > 0)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


bool CheckRightFrontSensor()
{
    if (SensorFrontRight > 0)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}


void CorrectToLeft()
{
        mL.SetPow(0.3); mR.SetPow(0.1);//nach links 
        wait_ms(100);
        mL.SetPow(0.3); mR.SetPow(0.3);//wieder geradeaus 
}


void CorrectToRight()
{
        mL.SetPow(0.1); mR.SetPow(0.3);//nach rechts
        wait_ms(100);
        mL.SetPow(0.3); mR.SetPow(0.3);//wieder geradeaus 
}
