#include "mbed.h"
#include "Fahrradleuchte.h"

//        LSB                                                      MSB
BusOut lb(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

//StatusLED zeigt uns in welchem Zustand die Statemachine gerade ist
BusOut stLED(P1_13,P1_12);

//BtnEventM0 erledigt di eAbfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw2(P0_15), sw1(P0_10), sw3(P0_23);
//sw4 = foreward, sw3 = backward

class Fahrradleuchte
{
    public: 
        void Init();
        void State1Func();//Funktionen, die auch von außerhalb der Klasse aufgerufen werden können
        void State2Func();
        void State3Func();
        void State1Action();//Aktionen, die auch von außen aufgerufen werden können  Bit2 (LED) mit 10 Hz blinken
        void State2Action();//Bit2(LED) mit 5 Hz blinken
        void State3Action();//Bit6(LED) mit 2 Hz blinken
    public: 
        int state;//zeigt an, in welchem Zustand sich die Leuchte befindet.
    private://Kann nur in dieser Klasse aufgerufen werden
        Timer t1;  
};//HIER: Klasse mit Strichpunkt beenden

Fahrradleuchte fl;//Objekt fl anlegen
//Fahrradleuchte fl2; zB...

int main(void)
{
    sw3.Init();//P0_23 backward
    sw4.Init();//P1_16 foreward
    fl.Init();//Objekt von Fahrradleuchte
    //fl2.Init(); zB...   
    while(1)
    {
        if(fl.state==1)
            fl.State1Func();
        if(fl.state==2)
            fl.State2Func();
        if(fl.state==3)
            fl.State3Func();

    } 
}

void Fahrradleuchte::Init()
{
    t1.start();
    state=1;    
    //fl.state=1; zB...
    //fl2.state =14; zB...
}

void Fahrradleuchte::State1Func()
{
    //einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED=1;//Anzeigen, dass wir im "state 1" sind
    while(1)
    {
        State1Action();
        //Buttons abfragen und möglicherweise Zustand ändern
        if(sw4.CheckFlag())
        {
            state=2;
            return;
        }
        if(sw3.CheckFlag())
        {
            state=3;
            return;
        }
    }
}
void Fahrradleuchte::State2Func()
{
    //einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED=1;//Anzeigen, dass wir im "state 1" sind
    while(1)
    {
        State1Action();
        //Buttons abfragen und möglicherweise Zustand ändern
        if(sw4.CheckFlag())
        {
            state=2;
            return;
        }
        if(sw3.CheckFlag())
        {
            state=3;
            return;
        }
    }
}
void Fahrradleuchte::State3Func()
{
    //einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED=1;//Anzeigen, dass wir im "state 1" sind
    while(1)
    {
        State1Action();
        //Buttons abfragen und möglicherweise Zustand ändern
        if(sw4.CheckFlag())
        {
            state=2;
            return;
        }
        if(sw3.CheckFlag())
        {
            state=3;
            return;
        }
    }
}

void Fahrradleuchte::State1Action()
{
    if(t1.read_ms()>100) //10Hz
    {
        t1.reset();
        if(lb==0)
            lb=4;
        else
            lb=0;
    }
}