#include "mbed.h"

class Motor {
	public:
		Motor(PinName pwm, PinName fwd, PinName rev);
    void SetBrake(int aOnOff);
		void SetPow(float aPow);
    void SetPow2(float aPow);
	protected:
    PwmOut _pwm;
    DigitalOut _fwd;
    DigitalOut _rev;
    int16_t    _running;
};

// Motor mL(P1_19,P2_15,P2_14); Motor mR(P2_19,P2_20,P2_21);

Motor::Motor(PinName pwm, PinName fwd, PinName rev) :
_pwm(pwm), _fwd(fwd), _rev(rev) 
{
	_pwm.period(0.001); _pwm=0;
	_fwd=0; _rev=0; _running=0;
}

void Motor::SetBrake(int aOnOff)
{
  _pwm=0;
  if( aOnOff )
    { _fwd=0; _rev=0; }
  else
    { _fwd=1; _rev=1; }
}

void Motor::SetPow(float aPow)
{
	if( aPow==0 ) {
    _pwm=0; _running=0; return;
  }
	if( aPow>=0.0 ) {
		_fwd=1; _rev=0;
		_pwm = aPow;
	}
	else {
		_fwd=0; _rev=1;
		_pwm = -aPow;
	}
	_running=1;
}

void Motor::SetPow2(float aPow)
{
  float pow;
  if( aPow==0 ) {
    _pwm=0; _running=0; return;
  }
	if( aPow>=0.0 ) {
		_fwd=1; _rev=0;
		pow = aPow;
	}
	else {
		_fwd=0; _rev=1;
		pow = -aPow;
	}
  if( !_running && (pow<0.3) ) {
    _pwm = 0.3;
    wait_ms(20); // 50
  }
  _pwm = pow;
  _running = 1;
}


class AnalogInHL2 : public AnalogIn {
  public:
    AnalogInHL2(PinName pin) : AnalogIn(pin) {}
    int Read()
			{ return read_u16()>>4; }
};



const int ENC_A = 1;
const int ENC_B = 2;
const int ENC_RISE = 1;
const int ENC_FALL = 2;

class Encoder {
  public:
    Encoder(PinName sensA, PinName sensB) :
		_sensA(sensA), _sensB(sensB)
		{ cnt=0; }
    
		void Init(int aAB, int aRiseFall)
		{
			if( aAB & ENC_A ) {
				if( aRiseFall & ENC_RISE ) 
					_sensA.rise(this, &Encoder::ISR_A);
				if( aRiseFall & ENC_FALL )
					_sensA.fall(this, &Encoder::ISR_A);
			}
			if( aAB & ENC_B ) {
				if( aRiseFall & ENC_RISE )
					_sensB.rise(this, &Encoder::ISR_B);
				if( aRiseFall & ENC_FALL )
					_sensB.fall(this, &Encoder::ISR_B);
			}
		}
    
		void ISR_A()
    {
			if( _sensB.read() )
				cnt++;
      else
        cnt--;
		}
		
		void ISR_B()
    {
			if( _sensA.read() )
        cnt++;
      else
        cnt--;
		}
  public:
    uint32_t cnt;
  public:
		InterruptIn _sensA;
		InterruptIn _sensB;
};



class DistSens {
	public:
		DistSens(PinName aEmitter, PinName aRecv) :
		_e(aEmitter), _r(aRecv)
		{ useLED=1; }

		int Measure()
		{
			int ret;
			if( useLED )
				{ _e=1; wait_us(500); }
			ret=_r.read_u16() >> 4;
			_e=0; return ret;
		}

	public:
		int useLED;
	private:
		DigitalOut _e;
    AnalogIn _r;
};


