#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,P1_6, P1_7);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

//AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15
void ButonBlinker();

//void MotorTest ();

void BackW ();
void ForW ();



int main(void)
{
    boardPow=1; wait_ms(10);
    InitBertl();
    pex.useISR=0; leds=9;
    pex.ClearLeds();
    
    pex.WaitUntilButtonPressed();
    while(1)
    {
       ButonBlinker();
       //MotorTest ();
        BackW ();
        wait_ms(1000);
        ForW ();
        wait_ms(1000);
    }
    
    return 1;
}

void ButonBlinker()
{
    pex.ReadButtons();
    
    if (pex.IsButton(BTN_FLL))
    {
        pex.SetLeds(LED_FL1|LED_FL2);
    }
    
    if (pex.IsButton(BTN_FRR))
    {
        pex.SetLeds(LED_FR1|LED_FR2);
    }
    wait_ms(100);
    pex.ClearLeds();
    wait_ms(100);
} 


/*
void MotorTest ()   
{
   if (pex.IsButton(BTN_FRR||BTN_FLL))
    {
        mL.SetPow(-0.2);
        mR.SetPow(-0.2);
    }
   
   
   else if (pex.IsButton(BTN_BR||BTN_BL))
    {
        mL.SetPow(0.2);
        mR.SetPow(0.2);
    }
   
   //mL.SetPow(0.2);
   //mR.SetPow(0.2);
   
   //wait_ms(2000);
    
    //mL.SetPow(-0.2);
    //mR.SetPow(-0.2);
   
   //wait_ms(2000);
    
}
*/

void BackW ()
{
     pex.ClearLeds();
    mL.SetPow(0.3);
    mR.SetPow(0.3);
    
    //pex.SetLeds(LED_FL1|LED_FL2);//Leds für die Fahrtrichtung
    //pex.SetLeds(LED_FR1|LED_FR2);
    pex.SetLeds(LED_FL1);//Leds für die Fahrtrichtung
    pex.SetLeds(LED_FR1);
   
    while (1 )
    {
        pex.ReadButtons();
        
        if( pex.IsAnyFrontButton() )
        {
            break;
        }
    
    }
    mL.SetPow(0);
    mR.SetPow(0);
    
    
}


void ForW ()
{
     pex.ClearLeds();
    mL.SetPow(-0.3);
    mR.SetPow(-0.3);
    
    pex.SetLeds(LED_BL1|LED_BL2);
    pex.SetLeds(LED_BR1|LED_BR2);
    
    while (1 )
    {
        pex.ReadButtons();
        
        if( pex.IsAnyBackButton() )
        {
            break;
        }
    
    }
    mL.SetPow(0);
    mR.SetPow(0);
    
}