#include "mbed.h"
#include "Serial_HL.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

AnalogIn a1(p19), a2(p20);

// V2.0
// BusOut leds(LED1,LED2,LED3,LED4); Bertl14
// M0-Board
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);


void CommandHandler();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);
    leds = 9;

    ua0.SvMessage("Analog in"); // Meldung zum PC senden

    int16_t sv1=0, sv2=100; float sv3=0;
    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( ua0.acqON && (stw.read_ms()>10) ) { // 100Hz
            // dieser Teil wird mit 100Hz aufgerufen
            stw.reset();
            sv1++;
            sv2++;
            sv3+=0.1;
            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde
                // wird auch etwas gesendet
                // << 4 Korrektur der MBed library für 12 bit ADC
                ua0.WriteSvI16(1, a1.read_u16() >> 4);
                ua0.WriteSvI16(2, a2.read_u16() >> 4);
            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;
    int16_t idata1, idata2;

    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;

    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

    if( cmd==2 ) {
        // cmd2 hat 2 int16 Parameter
        idata1 = ua0.ReadI16();
        idata2 = ua0.ReadI16();
        // für die Analyse den Wert einfach nur zum PC zurücksenden
        ua0.SvPrintf("Command2 %d %d", idata1, idata2);
    }   
    
    if( cmd==3 ) 
    {
        leds = ua0.ReadI16();
           
        ua0.SvMessage("SetLeds");
    }
}


