// ---------------- Switch Event Class  --------------------------
#include "mbed.h"
 
class SwEvent {
        InterruptIn _isr;
        volatile int16_t _pressed;
        void _risingISR();
 
    public:
        SwEvent(PinName pin) : _isr(pin) {          // create the InterruptIn on the pin specified to SwEvent
            _isr.rise(callback(this, &SwEvent::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0; 
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
};
// ---------------- Switch Event Class Methodes --------------------------
int SwEvent::checkFlag() {
    if( _pressed ) {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEvent::_risingISR() {            
    if( _isr.read() )
        _pressed = 1;
}

DigitalOut led(LED1, 0);
SerialEvent se(USBTX, USBRX);
 
 
 
int main() {
    char str[STRMAX];
    printf("Hello\n");
    while(1) {
        if(se.checkFlag()) {
            se.getString(str);
            printf("String: %s\n", str);
        }
    }
}