#include "mbed.h"
#include "C12832.h"
#define rgbRED 6
#define rgbBLUE 3
#define rgbYELLOW 4
#define rgbGREEN 5



C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn aiPoti1(p19);
AnalogIn aiPoti2(p20);
BusOut rgbLeds(p23, p24, p25);
 
class Counter {
public:
    Counter(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(callback(this, &Counter::increment)); // attach increment function of this counter instance
    }
 
    void increment() {
        _count++;
    }
 
    int read() {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};
 
Counter counter(p14);
 
int main() {
    while(1) 
    {
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(40,10);   // x-position, y-position (x: 0-128; y: 0-32)
        //lcd.printf("Bewerbung");
        lcd.printf("Count so far: %d\n", counter.read());
        wait(2);
    }
}



class SerialEvent
{
    private:
        Serial _isr;//_isr ist ein Objekt von Serial
        volatile int16_t _pressed;
        void _risingISR(); // nur innerhalb der Klasse zugreifbar
        char str;
    
    public:
        int checkFlag();
        void read(char& zeichen);
        SerialEvent(PinName tx, PinName rx):_isr(tx,rx)  //Konstroktor!!!
        {
            _isr.attach(callback(this, &SerialEvent::risingISR)))
        }
    
    void SerialEvent::_risingIsr(pin)
    {
        str = getc();
        _pressed = 1;
    }

    void SerialEvent::checkFlag()
    {
        if(_pressed)
        {
            pressed = 0;
            return true;
        }
        else
            return false;

    }
    
    void SerialEvent::read(char& zeichen)
    {
        zeichen = str;
    ]
    
/*    void _rinsingISR();
    {
        str = getc();
        _pressed = 1;
    }
    
    int checkFlag()
    {
        îf(_pressed)
        {
            _pressed = 0;
             return true;
        }
        else
            return false;
    }
  */  
    
    void main()
    {
        char z;
        
        if(pc.checkFlag())
        {
            pc.read(z);
        }
    }
    
};






/*
// ---------------- Switch Event Class  --------------------------
class SwEvent {
        InterruptIn _isr;
        volatile int16_t _pressed;// (flüchtige)private Elementvariable, die durch ISR gesetzt wird (steht nur einmal im Speicher)
        void _risingISR();
 
    public:
        SwEvent(PinName pin) : _isr(pin) {          // create the InterruptIn on the pin specified to SwEvent
            _isr.rise(callback(this, &SwEvent::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0; 
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
        void init();
};

// ---------------- Switch Event Class Methodes --------------------------
int SwEvent::checkFlag() 
{
    if( _pressed ) 
    {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEvent::_risingISR() {            
    if( _isr.read() )
        _pressed = 1;
}


*/