#include "mbed.h"
 
#define Device_Name_ADDR   (0xEE) // Device You Wish to Use Address - using i2c Address
#define WRITE              (0x00) // i2c Write bit
#define READ               (0x01) // i2c Read bit

/* This is a program to demonstrate the ease of use of the i2c bus
   and Detecting any Devices connected and returning their addresses
   Do not forget that Pull Up resistors are required on the SDA and SCL lines
   (Typically 2K ohms for 400KHz bus speeds) NB these could be provided on the PCB Modules.
   These are required since devices connected with the i2c will have 'open drain' (or open collector)
   circuitry to allow wire 'ORing' of their respective connections. Used with a stm32-Nucleo-F401RE.
   Used both Serial Port to USB and LCD Module to display results can use either or both just comment out if you wish.
   Martin Simpson January 2015 */

I2C i2c(I2C_SDA, I2C_SCL);       //I2C Class Pin Assignments see I2C.h
 
int main()
{
    
    char ucdata_write[2];
    short count=0;
    
    unsigned int uifrequency=400000; //400KHz for i2c Max
    i2c.frequency (uifrequency);
    
    printf("\n\rHello World ");
    printf("at %uKHz i2c Frequency\n\r",uifrequency/1000);
    printf("Using mbed.org Martin\n\r");

    ucdata_write[0]=0;ucdata_write[1]=0;

    for (int Device_Adress=0;Device_Adress<=0xFE;Device_Adress+=2)//Stepping in 2 Because Read/Write use LSB
    {
    if (!i2c.write((Device_Adress|WRITE), ucdata_write, 1, 0))// Check for ACK from i2c Device NB I am 'ORing' the Write Bit
        {
            printf("ACK from the Device at Address %#4x\n\r",Device_Adress);
            count++;
            wait(2);
        }
        else
        {
            //Left the following in for development/Future coding
            //pc.printf("\n\rCannot get an ACK from the Device check connections!\n\r");
            //lcd.printf("No ACK from\nDevice!");
        }
    }
    printf("\n\r %d Devices have been detected!\n\r",count);
}
