#include "mbed.h"

//Defines the digital in/out ports
DigitalOut led1(p16);
DigitalOut led2(p15);
DigitalOut led3(p14);
DigitalOut led4(p25);
DigitalOut led5(p26);

//To the spanish valentine´s day message (replace it for your own)
#define MATRIX_LENGTH 11
#define MESSAGE_LENGTH 65

int heart_matrix[5][MATRIX_LENGTH]= {
{0,0,1,1,0,0,0,1,1,0,0},
{0,1,1,1,1,0,1,1,1,1,0},
{0,0,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,0,0,0,0},
{0,0,0,0,0,1,0,0,0,0,0}
};

int message_matrix[5][MESSAGE_LENGTH]={
{1,1,1,0,1,1,1,0,1,0,0,0,1,0,1,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,1,0,0,0,1,1,1,0,1,0,0,1,0,1,1,1,0,1,0,1,0,0,1,0},
{1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,1,0,1,1,0,1,0},
{1,1,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,1,1,0,0,1,0,1,0,1,0,1,0,1,0,0,0,1,1,1,0,1,0,1,1,0,0,1,0,0,1,0,1,0,1,1,0},
{1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0},
{1,0,0,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,1,0,1,1,1,0,1,1,1,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0}
};

int main()
{
    unsigned char flag_start;
    unsigned char cont;
    unsigned char image;
    unsigned char state;
   
    cont=0;
    image=0;
    flag_start=50;
    state=0;

    led1=0;
    led2=0;
    led3=0;
    led4=0;
    led5=0;
   
     while(1)
     {
          switch(state)
          {
                case 0:
                    switch(image)
                    {
                           case 0:
                               led1 = heart_matrix[0][cont];
                               led2 = heart_matrix[1][cont];
                               led3 = heart_matrix[2][cont];
                               led4 = heart_matrix[3][cont];
                               led5 = heart_matrix[4][cont];
 
                               cont++;
                               if(cont>=MATRIX_LENGTH)
                               {
                                   cont=0;
                                   image=1; //Switch to another image
                               }
                               break;
 
                         case 1:
                              led1 = message_matrix[0][cont];
                              led2 = message_matrix[1][cont];
                              led3 = message_matrix[2][cont];
                              led4 = message_matrix[3][cont];
                              led5 = message_matrix[4][cont];
 
                              cont++;
                              if(cont>=MESSAGE_LENGTH)
                              {
                                   cont=0;
                                   image=0; //Switch to another image
                                   state=1;
                               }
                               break;
                       }

                      case 1:
                          if(flag_start>0)
                          {
                               flag_start--;
                          }
                          if(flag_start==0)
                          {
                              flag_start=80;
                              state=0;
                          }
                          break;
           }
          
           //Wait 3ms to change the leds on/off, this time depends the wider the letter
           wait_ms(3);
     }
}