#include "mbed.h"
#include "Robot.h"
#include "const.h"

class Bertl_Beeper : public Robot
{
public:
    void ClearAllBeeperToTheWall();
    void TurnAround();
};

void Bertl_Beeper :: TurnAround()
{
    TurnLeft();
    TurnLeft();
}

void Bertl_Beeper :: ClearAllBeeperToTheWall()
{
    while(FrontIsClear()) 
    {
        if(NextToABeeper()) 
        {
            PickBeeper();
            NibbleLeds(AnyBeeperInBag());
            wait(1);
            Move();
        } else
            Move();
    }
}

int main()
{
    Bertl_Beeper karel;

    while(1) 
    {
        karel.ClearAllBeeperToTheWall();
        while(!karel.FrontIsClear()) 
        {
            karel.TurnAround();
            break;
        }
    }
}