#ifndef __UTT_FOOBAR_H__
#define __UTT_FOOBAR_H__

#include "StateMachine.h"

class Foo : public State{

public:

    static const char* OUTCOME_BAR;

    Foo(const char* uuid, UserData *ud): 
      State(uuid){ 
        /* Capture UserData, see in utt_foobar_with_ud.h example. */ 
    }
    
    virtual void onEntry(){ 
        /* Do something before onExecute() */
    }
    
    virtual const char* onExecute(){
        /* Do something */
        return OUTCOME_BAR;
    }
    
    virtual void onExit(){
        /* Do something before exit state */
    }
};

const char* Foo::OUTCOME_BAR = "OUTCOME_BAR";

class Bar : public State{

public:

    static const char* OUTCOME_FOO;

    Bar(const char* uuid, UserData *ud):
      State(uuid){ 
        /* Capture UserData, see in utt_foobar_with_ud.h example. */ 
    }
    
    virtual void onEntry(){ 
        /* Do something before onExecute() */
    }
    
    virtual const char* onExecute(){
        /* Do something */
        return OUTCOME_FOO;
    }
    
    virtual void onExit(){
        /* Do something before exit state */
    }
};

const char* Bar::OUTCOME_FOO = "OUTCOME_FOO";

class FooBar : public StateMachine{

public:

    FooBar(const char* uuid):
        StateMachine(uuid),
        foo(NULL), bar(NULL)
    {
        // States instance with StateMachine context
        foo = this->Instance<Foo>("FOO");
        bar = this->Instance<Bar>("BAR");
        
        // Connect Foo to Bar
        this->connect(STATE(foo), Foo::OUTCOME_BAR, STATE(bar));
        
        // Connect Bar to Foo
        this->connect(STATE(bar), Bar::OUTCOME_FOO, STATE(foo));
        
        // Set the first state calling when the state machine starts
        this->setInitialState(STATE(foo)); 
    }

private:
    Foo *foo;
    Bar *bar;
};

// Preempt state mahine button
InterruptIn button(PC_13);

void unit_test(){
    
    FooBar foobar("FOOBAR_SM");
    
    button.rise(&foobar, &FooBar::preempt);
    
    foobar.printGraph();
    
    Logger::info("STATE MACHINE FINISHED WITH OUTCOME \"%s\"",foobar.execute()); 
}


#endif /* #ifndef __UTT_FOOBAR_H__*/