#include "Logger.h"
    
Logger::Logger(int _level){
    Logger::level = _level;
}

void Logger::debug(const char* format, ...){
    
    if (Logger::level == Logger::DEBUG){
        printf("[DEBUG] : ");
        va_list args;
        va_start(args,format);
        vprintf(format,args);
        va_end(args);
        printf("\n");
    }
}


void Logger::info(const char* format, ...){
    
    if (Logger::level <= Logger::INFO){
        printf("[INFO] : ");
        va_list args;
        va_start(args,format);
        vprintf(format,args);
        va_end(args);
        printf("\n");
    }
}

void Logger::warn(const char* format, ...){
    
    if (Logger::level <= Logger::WARNING){
        printf("[WARN] : ");
        va_list args;
        va_start(args,format);
        vprintf(format,args);
        va_end(args);
        printf("\n");
    }
}

void Logger::err(const char* format, ...){
    
    if (Logger::level <= Logger::ERROR){
        printf("[ERROR] : ");
        va_list args;
        va_start(args,format);
        vprintf(format,args);
        va_end(args);
        printf("\n");
    }
}

int Logger::level = Logger::DEBUG;
