////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : UserData.h
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __SM_USER_DATA_H__
#define __SM_USER_DATA_H__

#include "mbed.h"

#include "MetaData.h"

class UserData{

public:

    struct UserDataItem_t{
        
        const char     *key;
        void           *data;
        UserDataItem_t *next;
        
        UserDataItem_t(const char* _key, void* _data);
    };

    UserData();
    
    /** Registe template data
     *
     * @param const char* The data key
     * @param T           The pointer data
     */
    template<typename T>
    inline void put(const char* key, T *data){
        UserDataItem_t *newUserData = new UserDataItem_t(key, static_cast<void*>(data));
        this->put(newUserData);
    }
    
    /** Provide template data by key
     *
     * @param const char* The data key
     * @return T          The pointer data
     */
    template<typename T>
    inline T get(const char* key){
        
        UserDataItem_t *tmp = m_userDataList;
    
        while(tmp != NULL)
        {
            if (strcmp(tmp->key, key) == 0){
                return (T)(tmp->data);
            }
            tmp = tmp->next;
        }
        
        return NULL;
    }
    
private:

    void put(UserDataItem_t *ud);

    UserDataItem_t *m_userDataList;
    int             m_nbUserData;
};

#endif /* #ifndef __SM_USER_DATA_H__*/