////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : MetaData.h
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __LOGGER_H__
#define __LOGGER_H__

#include "mbed.h"

class Logger{

public:

    enum LoggerLevel_t{
        DEBUG = 0x00,
        INFO        ,
        WARNING     ,
        ERROR
    };
    
    static int level;
    
    Logger(int _level);

    static void debug(const char* format, ...);

    static void info(const char* format, ...);
    
    static void warn(const char* format, ...);
    
    static void err(const char* format, ...);
};

#endif /* #ifndef __LOGGER_H__*/