#ifndef __UTT_PARALLEL_STATES_2_H__
#define __UTT_PARALLEL_STATES_2_H__

#include "ParallelStateMachine.h"

class S1 : public State{

public:
    static OUTCOME CONTINUE;

    S1(const char* uuid, UserData* ud):
      State(uuid),
      m_count(0)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        m_count++;
        if (m_count > 20){
            m_count = 0;
            return SUCCEDED; 
        }
        
        return CONTINUE;    
    }
    
    virtual void onExit(){}
    
private:
    int m_count;
};

OUTCOME S1::CONTINUE = "CONTINUE";

class S2 : public State{

public:

    S2(const char* uuid, UserData* ud):
      State(uuid)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        return SUCCEDED;    
    }
    
    virtual void onExit(){}
};

class FooBar : public StateMachine{

public:

    FooBar(const char* uuid, UserData* ud):
      StateMachine(uuid, ud)
    {   
    
        S1 *s1 = this->Instance<S1>("S1");
        S2 *s2 = this->Instance<S2>("S2");  
    
        this->connect(STATE(s1), S1::CONTINUE, STATE(s2));
        this->connect(STATE(s1), S1::SUCCEDED, "DONE");
        
        this->connect(STATE(s2), S2::SUCCEDED, STATE(s1));
        
        this->setInitialState(STATE(s1));
    }
};

class SMRoot : public ParallelStateMachine{

public:
      
    SMRoot(const char* uuid, UserData* ud):
        ParallelStateMachine(uuid, ud){
        
        FooBar *foobar1 = Instance<FooBar>("FOO_BAR_1");
        FooBar *foobar2 = Instance<FooBar>("FOO_BAR_2");
        
        this->attachOutcomesResolver(this, &SMRoot::resolveOutcomes);
    }
    
    const char* resolveOutcomes(const char **outcomes, int number){
        
        
        if(strcmp(outcomes[0],"DONE")==0 && strcmp(outcomes[1], "DONE")==0){
            return "DONE";
        }
        
        return "FAIL";
    }
};

InterruptIn button(PC_13);
DigitalOut led(LED1);



void unit_test(){
    
    SMRoot root("ROOT", NULL);
    
    button.rise(&root, &StateMachine::preempt);

    root.printGraph();
    
    printf("%s RETURN %s\n", root.getUUID(), root.execute());
    
}

#endif /* #ifndef __UTT_PARALLEL_STATES_2_H__*/