#ifndef __UTT_PARALLEL_STATES_H__
#define __UTT_PARALLEL_STATES_H__

#include "ParallelStateMachine.h"

class S1 : public State{

public:
    static OUTCOME CONTINUE;

    S1(const char* uuid, UserData* ud):
      State(uuid),
      m_count(0)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        m_count++;
        if (m_count > 20){
            m_count = 0;
            return SUCCEDED; 
        }
        
        return CONTINUE;    
    }
    
    virtual void onExit(){}
    
private:
    int m_count;
};

OUTCOME S1::CONTINUE = "CONTINUE";

class S2 : public State{

public:

    S2(const char* uuid, UserData* ud):
      State(uuid)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        return SUCCEDED;    
    }
    
    virtual void onExit(){}
};

class FooBar : public StateMachine{

public:

    FooBar(const char* uuid, UserData* ud):
      StateMachine(uuid, ud)
    {   
    
        S1 *s1 = this->Instance<S1>("S1");
        S2 *s2 = this->Instance<S2>("S2");  
    
        this->connect(STATE(s1), S1::CONTINUE, STATE(s2));
        this->connect(STATE(s1), S1::SUCCEDED, "DONE");
        
        this->connect(STATE(s2), S2::SUCCEDED, STATE(s1));
        
        this->setInitialState(STATE(s1));
    }
};

InterruptIn button(PC_13);
DigitalOut led(LED1);

const char* resolveConcurrenceOutcomes(const char **outcomes, int number){
    
    
    if(strcmp(outcomes[0],"DONE")==0 && strcmp(outcomes[1], "DONE")==0){
        return "DONE";
    }
    
    return "FAIL";
}

void unit_test(){
    
    ParallelStateMachine root("ROOT");
    
    root.attachOutcomesResolver(&resolveConcurrenceOutcomes);
    button.rise(&root, &StateMachine::preempt);
    
    FooBar *foobar1 = root.Instance<FooBar>("FOO_BAR_1");
    FooBar *foobar2 = root.Instance<FooBar>("FOO_BAR_2");
    
    root.printGraph();
    
    printf("PARALLEL SM RETURN %s\n",root.execute());
    
}


#endif /* #ifndef __UTT_PARALLEL_STATES_H__*/