////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : Transitions.h
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __SM_TRANSITIONS_H__
#define __SM_TRANSITIONS_H__

#include <string>
#include "State.h"

class Transitions{
  
public:

    typedef struct Transition_t{
        
        const char   *outcome;
        const char   *_exit_;
        State        *target;
        Transition_t *next;
        
        Transition_t(const char* _outcome, State*  _target, const char* _exit=NULL);
        
    }Transition_t;

    Transitions();
    
    Transitions* addTransition(const char* outcome, State* target);
    
    Transitions* addTransition(Transition_t *transition);
    
    Transition_t* getTransition(const char* outcome);
    
    State* getTargetState(const char* outcome);
    
    void printList(string level="");
    
private:
    Transition_t *m_transitionsList;
};


#endif /* #ifndef __SM_TRANSITIONS_H__*/