////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : MetaData.h
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __SM_META_DATA_H__
#define __SM_META_DATA_H__

#include "mbed.h"

template<typename T>
class MetaData{

public:

    MetaData()
    {
        /* Empty */
    }
    
    MetaData(T data):
        m_data(data)
    {
        /* Empty */
    }
    
    void setData(T data){
        m_mutex.lock();
        m_data = data;
        m_mutex.unlock();
    }
    
    T getData(){ 
        m_mutex.lock();
        T data = m_data;
        m_mutex.unlock();
        return data;
    }
    
    T& operator=(T& other){
        if (sizeof(m_data) == sizeof(other.getData())){
            setData(other.getData());
        }
        return *this;
    }
    
private:
    T           m_data;
    Mutex       m_mutex;
};

/** Standard data decalration
 */
typedef MetaData<uint8_t>  DataUInt8;
typedef MetaData<int8_t>   DataInt8;
typedef MetaData<uint16_t> DataUInt16;
typedef MetaData<int16_t>  DataInt16;
typedef MetaData<uint32_t> DataUInt32;
typedef MetaData<int32_t>  DataInt32;
typedef MetaData<float>    DataFloat;
typedef MetaData<double>   DataDouble;

#endif /* #ifndef __SM_META_DATA_H__*/