#ifndef __UTT_HERACHICAL_SM_H__
#define __UTT_HERACHICAL_SM_H__


#include "mbed.h"
#include "StateMachine.h"

class S1 : public State{

public:
    static OUTCOME CONTINUE;

    S1(const char* uuid, UserData* ud):
      State(uuid),
      m_count(0)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        m_count++;
        if (m_count > 20){
            m_count = 0;
            return SUCCEDED; 
        }
        
        return CONTINUE;    
    }
    
    virtual void onExit(){}
    
private:
    int m_count;
};

OUTCOME S1::CONTINUE = "CONTINUE";

class S2 : public State{

public:

    S2(const char* uuid, UserData* ud):
      State(uuid)
    {
    }
    
    virtual void onEntry(){}
    
    virtual const char* onExecute(){
        return SUCCEDED;    
    }
    
    virtual void onExit(){}
};

class SMSub : public StateMachine{

public:

    SMSub(const char* uuid, UserData* ud):
      StateMachine(uuid, ud)
    {   
    
        S1 *s1 = this->Instance<S1>("S1");
        S2 *s2 = this->Instance<S2>("S2");  
    
        this->connect(STATE(s1), S1::CONTINUE, STATE(s2));
        this->connect(STATE(s1), S1::SUCCEDED, SUCCEDED);
        
        this->connect(STATE(s2), S2::SUCCEDED, STATE(s1));
        
        this->setInitialState(STATE(s1));
    }
};

class SMRoot : public StateMachine{

public:
    SMRoot(): StateMachine("ROOT"){
        
        S1* s1     = this->Instance<S1>("S1_R");
        S2* s2     = this->Instance<S2>("S2_R");
        SMSub* sub = this->Instance<SMSub>("SUB");
    
        this->connect(STATE(s1), S1::CONTINUE, STATE(s2));
        this->connect(STATE(s1), S1::SUCCEDED, STATE(sub));
        
        this->connect(STATE(s2), S2::SUCCEDED, STATE(s1));
        
        this->connect(STATE(sub), SMSub::SUCCEDED, SUCCEDED);
        
        this->setInitialState(STATE(s1));
    }
};

InterruptIn button(PC_13);
DigitalOut led(LED1);

void unit_test(){
    
    SMRoot root;
    
    button.rise(&root, &StateMachine::preempt);
    
    printf("SM FINISHED WITH OUTCOME %s\n",root.execute());
}

#endif /* #ifndef __UTT_HERACHICAL_SM_H__*/