////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : Transitions.cpp
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#include "Transitions.h"
#include "Logger.h"
    
Transitions::Transition_t::Transition_t(const char* _outcome, State*  _target, const char* _exit){
    outcome = _outcome;
    _exit_  = _exit;
    target  = _target;
    next    = NULL;
}

Transitions::Transitions():
    m_transitionsList(NULL)
{
    /* Empty */
}

Transitions* Transitions::addTransition(const char* outcome, State* target){
    
    Transition_t *newTransition = new Transition_t(outcome, target);
    
    if(m_transitionsList == NULL){
        
        m_transitionsList = newTransition;

    } else {
        
        Transition_t *temp = m_transitionsList;

        while(temp->next != NULL)
        {
            temp = temp->next;
        }
        temp->next = newTransition;
    }
    
    return this;
}

Transitions* Transitions::addTransition(Transition_t *transition){
    
    if(m_transitionsList == NULL){
        
        m_transitionsList = transition;

    } else {
        
        Transition_t *temp = m_transitionsList;

        while(temp->next != NULL)
        {
            temp = temp->next;
        }
        temp->next = transition;
    }
    
    return this;  
}

Transitions::Transition_t* Transitions::getTransition(const char* outcome){
    
    Transition_t *tmp = m_transitionsList;

    while(tmp != NULL)
    {
        if (strcmp(tmp->outcome, outcome) == 0){
            return tmp;
        }
        tmp = tmp->next;
    }
    
    return NULL;
}

State* Transitions::getTargetState(const char* outcome){
    
    Transition_t *tmp = m_transitionsList;

    while(tmp != NULL)
    {
        if (strcmp(tmp->outcome, outcome) == 0){
            return tmp->target;
        }
        tmp = tmp->next;
    }
    
    return NULL;
}

void Transitions::printList(string level){
    
    Transition_t *tmp = m_transitionsList;

    while(tmp != NULL)
    {
        
        if (tmp->target != NULL){
            Logger::debug("%s    - OUTCOME(%s) -> TRAGET(%s)",
                           level.c_str(),
                           tmp->outcome,
                           tmp->target->getUUID()); 
        }
        else{
            Logger::debug("%s    - OUTCOME(%s) -> EXIT(%s)",
                           level.c_str(),
                           tmp->outcome,
                           tmp->_exit_);
        }
        tmp = tmp->next;
    } 
}