////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : State.cpp
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#include "State.h"

bool preempt_flag = false;

const char* State::SUCCEDED  = "SUCCEDED";
const char* State::ABORTED   = "ABORTED";
const char* State::PREEMPTED = "PREEMPTED";

State::State(const char* uuid,
             StateType_t type):
    m_uuid(uuid),
    m_type(type),
    m_preempt(false),
    m_outcome(NULL)
{
    /* Empty */
}

void State::setUUID(const char* uuid){
    m_uuid = uuid;
}

const char* State::getUUID(){
    return m_uuid;
}

void State::setType(State::StateType_t type){
    m_type = type;
}

State::StateType_t State::getType(){
    return m_type;    
}

void State::_onParallelExecute(){
    m_outcome = onExecute();
}

const char* State::getOutcome(){
   return m_outcome; 
} 

void State::preempt(){
    preempt_flag = true;
}

bool State::isPreempted(){
    return preempt_flag; 
}
