#ifndef __UTT_FOOBAR_WUD_H__
#define __UTT_FOOBAR_WUD_H__

#include "StateMachine.h"

class Foo : public State{

public:

    static const char* OUTCOME_BAR;

    Foo(const char* uuid, UserData *ud):
        State(uuid),
        _count(0)
    {
        // Capture data ptr by key
        _data = ud->get<DataInt32*>("COUNT");
    }
    
    virtual void onEntry(){ /* Do something */ }
    
    virtual const char* onExecute(){
        
        _count++;
        
        return OUTCOME_BAR;
    }
    
    virtual void onExit(){
        // Update data
        _data->setData(_count);
    }
        
private:
    int _count;
    DataInt32 *_data;
};

const char* Foo::OUTCOME_BAR = "OUTCOME_BAR";

class Bar : public State{

public:

    static const char* OUTCOME_FOO;

    Bar(const char* uuid, UserData *ud):
      State(uuid)
    {
        // Capture data ptr
        _data = ud->get<DataInt32*>("COUNT");
    }
    
    virtual void onEntry(){
    }
    
    virtual const char* onExecute(){
        
        Logger::info("COUNT : %i",_data->getData());
        
        // Check data value
        if (_data->getData() >= 20){
            return SUCCEDED;    
        }
        
        return OUTCOME_FOO;
    }
    
    virtual void onExit(){    
    }
    
private:
    DataInt32 *_data;
};

const char* Bar::OUTCOME_FOO = "OUTCOME_FOO";

class FooBar : public StateMachine{

public:

    FooBar(const char* uuid, UserData *ud):
        StateMachine(uuid, ud),
        foo(NULL), bar(NULL)
    {
        // States instance
        foo = this->Instance<Foo>("FOO");
        bar = this->Instance<Bar>("BAR");
        
        // Connect Foo to Bar
        this->connect(STATE(foo), Foo::OUTCOME_BAR, STATE(bar));
        
        // Connect Bar to Foo
        this->connect(STATE(bar), Bar::OUTCOME_FOO, STATE(foo));
        
        // Connect Bar to exit state machine
        this->connect(STATE(bar), Bar::SUCCEDED, SUCCEDED);
        
        this->setInitialState(STATE(foo)); 
    }

private:
    Foo *foo;
    Bar *bar;
};


InterruptIn button(PC_13);

void unit_test(){
    
    StateMachine root("FOOBAR_ROOT");
    
    button.rise(&root, &FooBar::preempt);
    
    DataInt32* data = new DataInt32(0);
    
    root.getUserData()->put("COUNT", data);
    
    FooBar *foobar1 = root.Instance<FooBar>("FOOBAR_1");
    FooBar *foobar2 = root.Instance<FooBar>("FOOBAR_2");
    
    root.setInitialState(STATE(foobar1));
    
    root.connect(STATE(foobar1), "SUCCEDED", STATE(foobar2));
    root.connect(STATE(foobar2), "SUCCEDED", "SUCCEDED");
    
    root.printGraph();
    
    printf("STATE MACHINE RETURN %s \n",root.execute()); 
}


#endif /* #ifndef __UTT_FOOBAR_WUD_H__*/