////////////////////////////////////////////////////////////////////////////////
// Copyright Rottor SAS 2017
// All rigths reserved.
//
// File Name : UserData.cpp
// Authors : Martin Matignon
//
// If you find any bug or if you have any question please contact
// Martin Matignon <martin.matignon@rottor.fr>
// Nicolas Forestier <nicolas.forestier@rottor.fr>
//
////////////////////////////////////////////////////////////////////////////////

#include "UserData.h"

UserData::UserDataItem_t::UserDataItem_t(const char* _key, void* _data){
    key  = _key;
    data = _data;
    next = NULL;
}


UserData::UserData():
    m_userDataList(NULL),
    m_nbUserData(0)
{
    /* Empty */
}

void UserData::put(UserDataItem_t *ud){
    
    if(m_userDataList == NULL){
        
        m_userDataList = ud;

    } else {
        
        UserDataItem_t *temp = m_userDataList;

        while(temp->next != NULL)
        {
            temp = temp->next;
        }
        temp->next = ud;
    }
    
    m_nbUserData++;
}
