// undef windows definitions that are also 4DGL definitions

//------------------------------------------------------------------------------
//txt_Set() related constants
//------------------------------------------------------------------------------
#define GFX_TEXT_COLOUR             0 // text foreground colr
#define GFX_TEXT_BACKGROUND         1 // text background colr
#define GFX_TEXT_HIGHLIGHT          1 // text background colr
#define GFX_FONT_ID                 2 // default 0, else points to data statement font
#define GFX_FONT_SIZE               2 // compatibility
#define GFX_TEXT_WIDTH              3 // text width multiplier
#define GFX_TEXT_HEIGHT             4 // text height multiplier
#define GFX_TEXT_XGAP               5 // horizontal text gap (default 1)
#define GFX_TEXT_YGAP               6 // vertical text gap (default 1)
#define GFX_TEXT_PRINTDELAY         7 // for 'teletype' like effect when printing
#define GFX_TEXT_OPACITY            8 // text mode flag, TRANSPARENT or OPAQUE
#define GFX_TEXT_BOLD               9 // embolden text (auto reset)
#define GFX_TEXT_ITALIC             10 // italicize text (auto reset)
#define GFX_TEXT_INVERSE            11 // invert text (auto reset)
#define GFX_TEXT_UNDERLINED         12 // underline text (auto reset)
#define GFX_TEXT_ATTRIBUTES         13 // controls BOLD/ITALIC/INVERSE/UNDERLINE simultaneously
#define GFX_TEXT_WRAP               14 // Sets the pixel position where text wrap will occur at RHS
#define GFX_TEXT_ANGLE              15 // Sets the text angle, only for plotted font

//------------------------------------------------------------------------------
//txt_Set() related arguments
//------------------------------------------------------------------------------
    // (legacy compatibility)
#define GFX_FONT1                   1 // font_System_5x7
#define GFX_FONT2                   2 // font_System_8x8
#define GFX_FONT3                   3 // font_System_8x12

    // new font constants
#define GFX_FONT_1                  1 // font_System_5x7
#define GFX_FONT_2                  2 // font_System_8x8
#define GFX_FONT_3                  3 // font_System_8x12
#define GFX_FONT_4                  4 // font_System_12x16
#define GFX_FONT_5                  5 // font_MS_SanSerif8x12
#define GFX_FONT_6                  6 // font_dejaVuSansCondensed9pt
#define GFX_FONT_7                  7 // font_dejaVuSans9pt
#define GFX_FONT_8                  8 // font_dejaVuSansBold9pt
#define GFX_FONT_9                  9 // font_System_3x6
#define GFX_FONT_10                 10 // font_plotted
#define GFX_FONT_11                 11 // EGA 8x12 font

#define GFX_TRANSPARENT             0 // TEXT_OPACITY  transparent  text
#define GFX_OPAQUE                  1 // TEXT_OPACITY  opaque text

#define GFX_BOLD                    16 // TEXT_ATTRIBUTES bold text
#define GFX_ITALIC                  32 // TEXT_ATTRIBUTES italic text
#define GFX_INVERSE                 64 // TEXT_ATTRIBUTES inverse text
#define GFX_UNDERLINED              128 // TEXT_ATTRIBUTES underlined

// single word array operations
#define GFX_OP1_NOP                 0 // no operation
#define GFX_OP1_SET                 1 // "set" the entire array with "value"
#define GFX_OP1_AND                 2 // "and" the entire array with "value"
#define GFX_OP1_IOR                 3 // "inclsuve or" the entire array with "value"
#define GFX_OP1_XOR                 4 // "exclusive or" the entire array with "value"
#define GFX_OP1_ADD                 5 // signed add each element of entire array with "value"
#define GFX_OP1_SUB                 6 // signed subtract "value" from each element of entire array.
#define GFX_OP1_MUL                 7 // signed multiply each element of entire array by "value"
#define GFX_OP1_DIV                 8 // signed divide each element of entire array by "value"
#define GFX_OP1_REV                 9 // reverse the elements of an array (value is ignored)
#define GFX_OP1_SHL                 10 // shift an array left by "value" positions
#define GFX_OP1_SHR                 11 // shift an array right by "value" positions
#define GFX_OP1_ROL                 12 // rotate an array left by "value" positions
#define GFX_OP1_ROR                 13 // rotate an array right by "value" positions
    // graphics only operations
#define GFX_OP1_GRAY                14 // convert an array of RGB565 elements to grayscale, "value" is ignored
#define GFX_OP1_WHITEN              15 // saturate an array of RGB565 elements to white, "value" determines saturation
#define GFX_OP1_BLACKEN             16 // saturate an array of RGB565 elements to black, "value" determines saturation
#define GFX_OP1_LIGHTEN             17 // increase luminance of an array of RGB565 elements, "value" determines saturation
#define GFX_OP1_DARKEN              18 // decrease luminance of an array of RGB565 elements, "value" determines saturation

// dual word array operations
    // boolean and math operations
#define GFX_OP2_AND                 1 // "and" arrays, result to array1 (value is ignored)
#define GFX_OP2_IOR                 2 // "inclusive or" arrays, result to array1 (value is ignored)
#define GFX_OP2_XOR                 3 // "exclusive or" arrays, result to array1 (value is ignored)
#define GFX_OP2_ADD                 4 // "add" arrays, result to array1, array1 + (array2+value)
#define GFX_OP2_SUB                 5 // "subtract" array2 from array1, result to array1, array1 - (array2+value)
#define GFX_OP2_MUL                 6 // "multiply" arrays, result to array1 (value is ignored)
#define GFX_OP2_DIV                 7 // "divide array1 by array2" , result to array1 (value is ignored)
#define GFX_OP2_COPY                8 // "copy" array2 to array1 (value is ignored)
    // graphics only operations
#define GFX_OP2_BLEND               9 // blend arrays, blend percentage determined by "value", result to "array1"


//------------------------------------------------------------------//
// Pin related constants                                            //
//------------------------------------------------------------------//

// pin_Set(...) pin modes
#define GFX_PIN_INP                 0 // pin is input, no pullup or pulldown
#define GFX_PIN_INP_HI              1 // pin is input with pullup to Vcc
#define GFX_PIN_INP_LO              2 // pin is input with pulldown to Gnd
#define GFX_PIN_OUT                 3 // pin is output
#define GFX_PIN_OUT_OD              4 // pin is output with open drain
#define GFX_PIN_AN                  5 // pin is analogue (PA0 to PA3 only)
#define GFX_PIN_ANAVG               6 // pin is analogue (PA0 to PA3 only), averaged - 16 samples


// pin name             constant    connector H1 I/O Pin referencesnumbers
#define GFX_PA0                     1 // pin 1
#define GFX_PA1                     2 // pin 3
#define GFX_PA2                     3 // pin 5
#define GFX_BUS_WR_PIN              3 // pin 5 (alias PA2_PIN)
#define GFX_PA3                     4 // pin 7
#define GFX_BUS_RD_PIN              4 // pin 7 (alias PA3_PIN)
#define GFX_PA4                     5 // pin 29
#define GFX_PA5                     6 // pin 27
#define GFX_PA6                     7 // pin 25
#define GFX_PA7                     8 // pin 23
#define GFX_PA8                     9 // pin 21
#define GFX_PA9                     10 // pin 19
#define GFX_PA10                    11 // pin 8  (LCD power control)
#define GFX_PA11                    12 // pin 6
#define GFX_PA12                    13 // pin 28 (TX1)
#define GFX_PA13                    14 // pin 30 (RX1)
#define GFX_PA14                    15 // pin 10 (input only)
#define GFX_PA15                    16 // pin 12 (input only)
#define GFX_AUDIO_ENABLE            17 // pin 45 (Output only)

// bit position masks
#define GFX_M_PA0                   0x0001 // pin 1
#define GFX_M_PA1                   0x0002 // pin 3
#define GFX_M_PA2                   0x0004 // pin 5
#define GFX_M_PA3                   0x0008 // pin 7
#define GFX_M_PA4                   0x0010 // pin 29
#define GFX_M_PA5                   0x0020 // pin 27
#define GFX_M_PA6                   0x0040 // pin 25
#define GFX_M_PA7                   0x0080 // pin 23
#define GFX_M_PA8                   0x0100 // pin 21
#define GFX_M_PA9                   0x0200 // pin 19 (LCD power control)
#define GFX_M_PA10                  0x0400 // pin 8
#define GFX_M_PA11                  0x0800 // pin 6
#define GFX_M_PA12                  0x1000 // pin 28
#define GFX_M_PA13                  0x2000 // pin 30
#define GFX_M_PA14                  0x4000 // pin 10 (input only)
#define GFX_M_PA15                  0x8000 // pin 12 (input only)



//------------------------------------------------------------------------------
//gfx_Set() related constants
//------------------------------------------------------------------------------
#define GFX_PEN_SIZE                16 // not necessary to use (legacy mode)
#define GFX_BACKGROUND_COLOUR       17 
#define GFX_OBJECT_COLOUR           18 // line / circle / rectangle generic colour
#define GFX_CLIPPING                19 // clipping ON / OFF
#define GFX_TRANSPARENT_COLOUR      20 // (only on displays with specific hware feature)
#define GFX_TRANSPARENCY            21 // 0 = OFF, 1 = ON (only on displays with specific hware feature)
#define GFX_FRAME_DELAY             22 // legacy mode, see pokeB(IMAGE_DELAY, n);
#define GFX_SCREEN_MODE             23 // LANDSCAPE, LANDSCAPE_R, PORTRAIT, PORTRAIT_R
#define GFX_OUTLINE_COLOUR          24 // if not BLACK (0) , used for outline around circles,rectangles and filled polygons
#define GFX_CONTRAST                25 // for OLED,cahnge contrast, for LCD on or off only
#define GFX_LINE_PATTERN            26 // used for patterned lines, 16bit value (0 = no pattern, '1's = pattern)
#define GFX_BEVEL_RADIUS            27 // button bevel radius
#define GFX_BEVEL_WIDTH             28 // button bevel width
#define GFX_BEVEL_SHADOW            29 // button bevel shadow depth
#define GFX_X_ORIGIN                30 // display position X offset
#define GFX_Y_ORIGIN                31 // display position X offset

// built in fill pattern constants for function gfx_FillPattern
#define GFX_FILLPATTERN_0           0xFFE0 
#define GFX_FILLPATTERN_1           0xFFE1 
#define GFX_FILLPATTERN_2           0xFFE2 
#define GFX_FILLPATTERN_3           0xFFE3 
#define GFX_FILLPATTERN_4           0xFFE4 
#define GFX_FILLPATTERN_5           0xFFE5 
#define GFX_FILLPATTERN_6           0xFFE6 
#define GFX_FILLPATTERN_7           0xFFE7 
#define GFX_FILLPATTERN_8           0xFFE8 
#define GFX_FILLPATTERN_9           0xFFE9 
#define GFX_FILLPATTERN_10          0xFFEA 
#define GFX_FILLPATTERN_11          0xFFEB 
#define GFX_FILLPATTERN_12          0xFFEC 
#define GFX_FILLPATTERN_13          0xFFED 
#define GFX_FILLPATTERN_14          0xFFEE 
#define GFX_FILLPATTERN_15          0xFFEF 
#define GFX_FILLPATTERN_16          0xFFF0 
#define GFX_FILLPATTERN_17          0xFFF1 
#define GFX_FILLPATTERN_18          0xFFF2 
#define GFX_FILLPATTERN_19          0xFFF3 
#define GFX_FILLPATTERN_20          0xFFF4 
#define GFX_FILLPATTERN_21          0xFFF5 
#define GFX_FILLPATTERN_22          0xFFF6 
#define GFX_FILLPATTERN_23          0xFFF7 
#define GFX_FILLPATTERN_24          0xFFF8 
#define GFX_FILLPATTERN_25          0xFFF9 
#define GFX_FILLPATTERN_26          0xFFFA 
#define GFX_FILLPATTERN_27          0xFFFB 
#define GFX_FILLPATTERN_28          0xFFFC 
#define GFX_FILLPATTERN_29          0xFFFD 
#define GFX_FILLPATTERN_30          0xFFFE 
#define GFX_FILLPATTERN_31          0xFFFF 

#define GFX_PTN_EMPTY               0xFFE0 
#define GFX_PTN_SOLID               0xFFE1 
#define GFX_PTN_FINE_DOTS           0xFFE2 
#define GFX_PTN_MEDIUM_DOTS         0xFFE3 
#define GFX_PTN_COURSE_DOTS         0xFFE4 
#define GFX_PTN_BS_VERTICAL         0xFFE5 
#define GFX_PTN_BS_HORIZONTAL       0xFFE6 
#define GFX_PTN_COURSE_F_DIAGONAL   0xFFE7 
#define GFX_PTN_COURSE_B_DIAGONAL   0xFFE8 
#define GFX_PTN_COURSE_CROSS        0xFFE9 
#define GFX_PTN_COURSE_DIAGONALCROSS  0xFFEA 
#define GFX_PTN_BSVERTICAL          0xFFEB 
#define GFX_PTN_BSHORIZONTAL        0xFFEC 
#define GFX_PTN_FDIAGONAL           0xFFED 
#define GFX_PTN_BDIAGONAL           0xFFEE 
#define GFX_PTN_FINE_CROSS          0xFFEF 
#define GFX_PTN_FINE_DIAGONAL_CROSS  0xFFF0 
#define GFX_PTN_BRICKS              0xFFF1 
#define GFX_PTN_CARGONET            0xFFF2 
#define GFX_PTN_CIRCUITS            0xFFF3 
#define GFX_PTN_COBBLESTONES        0xFFF4 
#define GFX_PTN_DAISIES             0xFFF5 
#define GFX_PTN_DIZZY               0xFFF6 
#define GFX_PTN_FIELDEFFECT         0xFFF7 
#define GFX_PTN_KEY                 0xFFF8 
#define GFX_PTN_ROUNDER             0xFFF9 
#define GFX_PTN_SCALES              0xFFFA 
#define GFX_PTN_STONE               0xFFFB 
#define GFX_PTN_THATCHES            0xFFFC 
#define GFX_PTN_TILE                0xFFFD 
#define GFX_PTN_WAFFLESREVENGE      0xFFFE 
#define GFX_PTN_CROSSES             0xFFFF 

//------------------------------------------------------------------//
//     gradient control constants                                   //
//------------------------------------------------------------------//
#define GFX_GRAD_DOWN               0x20 // gradient changes in the vertical direction
#define GFX_GRAD_RIGHT              0x30 // gradient change in the horizontal direction
#define GFX_GRAD_UP                 0x40 // gradient changes in the vertical direction
#define GFX_GRAD_LEFT               0x50 // gradient change in the horizontal direction
#define GFX_GRAD_WAVE_VER           0x60 // gradient wave in the vertical direction
#define GFX_GRAD_WAVE_HOR           0x70 // gradient wave in the horizontal direction

// baud divisor rates for legacy setbaud(n);
#define GFX_MIDI                    9 
#define GFX_BAUD_110                0 
#define GFX_BAUD_300                1 
#define GFX_BAUD_600                2 
#define GFX_BAUD_1200               3 
#define GFX_BAUD_2400               4 
#define GFX_BAUD_4800               5 
#define GFX_BAUD_9600               6 
#define GFX_BAUD_14400              7 
#define GFX_BAUD_19200              8 
#define GFX_BAUD_31250              9 
#define GFX_BAUD_38400              10 
#define GFX_BAUD_56000              11 
#define GFX_BAUD_57600              12 
#define GFX_BAUD_115200             13 
#define GFX_BAUD_128000             14 
#define GFX_BAUD_256000             15 
#define GFX_BAUD_300000             16 
#define GFX_BAUD_375000             17 
#define GFX_BAUD_500000             18 
#define GFX_BAUD_600000             19 


// I2C software emulation timing related constants
#define GFX_I2C_SLOW                0 // 100Khz
#define GFX_I2C_MED                 1 // 400Khz
#define GFX_I2C_FAST                2 // 5Mhz
#define GFX_I2C_10KHZ               3 // 10khz
#define GFX_I2C_20HZ                4 // 20khz
#define GFX_I2C_50KHZ               5 // 50khz
#define GFX_I2C_250KHZ              6 // 250khz


//------------------------------------------------------------------------------
// Constants for SPI1, SPI2 an SPI3 "mode"
//------------------------------------------------------------------------------
#define GFX_SPI8_MODE_0             0 //    8bit mode    SCK idles low,    SDO stable for first falling edge, SDI sampled on first falling edge
#define GFX_SPI8_MODE_1             1 //    8bit mode    SCK idles low,    SDO stable for first rising edge,  SDI sampled on first rising edge
#define GFX_SPI8_MODE_2             2 //    8bit mode    SCK idles high,    SDO stable for first falling edge, SDI sampled on first falling edge
#define GFX_SPI8_MODE_3             3 //    8bit mode    SCK idles high,    SDO stable for first rising edge,  SDI sampled on first falling edge
#define GFX_SPI8_MODE_4             4 //    8bit mode    SCK idles low,    SDO stable for first falling edge, SDI sampled on next rising edge
#define GFX_SPI8_MODE_5             5 //    8bit mode    SCK idles low,    SDO stable for first rising edge,  SDI sampled on next falling edge
#define GFX_SPI8_MODE_6             6 //    8bit mode    SCK idles high,    SDO stable for first falling edge, SDI sampled on next rising edge
#define GFX_SPI8_MODE_7             7 //    8bit mode    SCK idles high,    SDO stable for first rising edge,  SDI sampled on next rising edge
#define GFX_SPI16_MODE_0            8 //    16bit mode    SCK idles low,    SDO stable for first falling edge, SDI sampled on first falling edge
#define GFX_SPI16_MODE_1            9 //    16bit mode    SCK idles low,    SDO stable for first rising edge,  SDI sampled on first rising edge
#define GFX_SPI16_MODE_2            10 //    16bit mode    SCK idles high,    SDO stable for first falling edge, SDI sampled on first falling edge
#define GFX_SPI16_MODE_3            11 //    16bit mode    SCK idles high,    SDO stable for first rising edge,  SDI sampled on first falling edge
#define GFX_SPI16_MODE_4            12 //    16bit mode    SCK idles low,    SDO stable for first falling edge, SDI sampled on next rising edge
#define GFX_SPI16_MODE_5            13 //    16bit mode    SCK idles low,    SDO stable for first rising edge,  SDI sampled on next falling edge
#define GFX_SPI16_MODE_6            14 //    16bit mode    SCK idles high,    SDO stable for first falling edge, SDI sampled on next rising edge
#define GFX_SPI16_MODE_7            15 //    16bit mode    SCK idles high,    SDO stable for first rising edge,  SDI sampled on next rising edge

//------------------------------------------------------------------------------
// Constants for SPI1, SPI2 an SPI3 "speed"
//------------------------------------------------------------------------------
#define GFX_SPI_SPEED0              0 // 78.125 khz
#define GFX_SPI_SPEED1              1 // 109.375 khz
#define GFX_SPI_SPEED2              2 // 273.4375 khz
#define GFX_SPI_SPEED3              3 // 312.5 khz
#define GFX_SPI_SPEED4              4 // 437.5 khz
#define GFX_SPI_SPEED5              5 // 729.166 khz
#define GFX_SPI_SPEED6              6 // 1.09375 mhz
#define GFX_SPI_SPEED7              7 // 1.25 mhz
#define GFX_SPI_SPEED8              8 // 1.75 mhz
#define GFX_SPI_SPEED9              9 // 2.1875 mhaz
#define GFX_SPI_SPEED10             10 // 4.375 mhz
#define GFX_SPI_SPEED11             11 // 5.00 mhz
#define GFX_SPI_SPEED12             12 // 7.00 mhz
#define GFX_SPI_SPEED13             13 // 8.75 mhz
#define GFX_SPI_SPEED14             14 // 11.666 mhz
#define GFX_SPI_SPEED15             15 // 17.5 mhz

// image control header offsets
#define GFX_IMG_COUNT               0 
#define GFX_IMG_ENTRYLEN            1 
#define GFX_IMG_MODE                2 
#define GFX_IMG_GCI_FILENAME        3 
#define GFX_IMG_DAT_FILENAME        4 
#define GFX_IMG_GCIFILE_HANDLE      5 

// image control entry offsets
#define GFX_IMAGE_LOWORD            0 // WORD image address LO
#define GFX_IMAGE_HIWORD            1 // WORD image address HI
#define GFX_IMAGE_XPOS              2 // WORD image location X
#define GFX_IMAGE_YPOS              3 // WORD image location Y
#define GFX_IMAGE_WIDTH             4 // WORD image width
#define GFX_IMAGE_HEIGHT            5 // WORD image height
#define GFX_IMAGE_FLAGS             6 // WORD image flags
#define GFX_IMAGE_DELAY             7 // WORD inter frame delay
#define GFX_IMAGE_FRAMES            8 // WORD number of frames
#define GFX_IMAGE_INDEX             9 // WORD current frame
#define GFX_IMAGE_CLUSTER           10 // WORD image start cluster  pos (for FAT16 only)
#define GFX_IMAGE_SECTOR            11 // WORD image start sector in cluster pos (for FAT16 only)
#define GFX_IMAGE_TAG               12 // WORD user variable #1
#define GFX_IMAGE_TAG2              13 // WORD user variable #2

// image attribute flags (in IMAGE_FLAGS)
// for img_SetAttributes(...) and img_ClearAttributes(...)
#define GFX_I_ENABLED               0x8000 // bit 15,  set for image enabled
#define GFX_I_DARKEN                0x4000 // bit 14,  display dimmed
#define GFX_I_LIGHTEN               0x2000 // bit 13,  display bright
#define GFX_I_TOUCHED               0x1000 // bit 12,  touch test result
#define GFX_I_Y_LOCK                0x0800 // bit 11,  stop Y movement
#define GFX_I_X_LOCK                0x0400 // bit 10,  stop X movement
#define GFX_I_TOPMOST               0x0200 // bit 9,   draw on top of other images next update (auto reset)
#define GFX_I_STAYONTOP             0x0100 // bit 8,   draw on top of other images always
#define GFX_I_MOVIE                 0x0080 // bit 7,   image is a movie
#define GFX_I_NOGROUP               0x0040 // bit 6,   set to exclude image refresh when using img_Show(hndl, ALL);
#define GFX_I_TOUCH_DISABLE         0x0020 // bit 5,   set to disable touch for this image, default=1 for movie, 0 for image
#define GFX_I_COLOUR16              0x0010 // bit 4,   indicates 16 bit colour mode
    // bits 0-3 reserved



//touch_Set() related constants
#define GFX_TOUCH_ENABLE            0 
#define GFX_TOUCH_DISABLE           1 
#define GFX_TOUCH_REGIONDEFAULT     2 

//touch_Get() related constants
#define GFX_TOUCH_STATUS            0 
#define GFX_TOUCH_GETX              1 
#define GFX_TOUCH_GETY              2 
#define GFX_NOTOUCH                 0 
#define GFX_TOUCH_PRESSED           1 
#define GFX_TOUCH_RELEASED          2 
#define GFX_TOUCH_MOVING            3 

//------------------------------------------------------------------------------
// FILEIO Error Code Constants
//------------------------------------------------------------------------------
#define GFX_FE_OK                   0 // IDE function succeeded
#define GFX_FE_IDE_ERROR            1 // IDE command execution error
#define GFX_FE_NOT_PRESENT          2 // CARD not present
#define GFX_FE_PARTITION_TYPE       3 // WRONG partition type, not FAT16
#define GFX_FE_INVALID_MBR          4 // MBR sector invalid signature
#define GFX_FE_INVALID_BR           5 // Boot Record invalid signature
#define GFX_FE_DISK_NOT_MNTD        6 // Media not mounted
#define GFX_FE_FILE_NOT_FOUND       7 // File not found in open for read
#define GFX_FE_INVALID_FILE         8 // File not open
#define GFX_FE_FAT_EOF              9 // Fat attempt to read beyond EOF
#define GFX_FE_EOF                  10 // Reached the end of file
#define GFX_FE_INVALID_CLUSTER      11 // Invalid cluster value > maxcls
#define GFX_FE_DIR_FULL             12 // All root dir entry are taken
#define GFX_FE_DISK_FULL            13 // All clusters in partition are taken
#define GFX_FE_FILE_OVERWRITE       14 // A file with same name exist already
#define GFX_FE_CANNOT_INIT          15 // Cannot init the CARD
#define GFX_FE_CANNOT_READ_MBR      16 // Cannot read the MBR
#define GFX_FE_MALLOC_FAILED        17 // Malloc could not allocate the FILE struct
#define GFX_FE_INVALID_MODE         18 // Mode was not r.w.
#define GFX_FE_FIND_ERROR           19 // Failure during FILE search
#define GFX_FE_INVALID_FNAME        20 // bad filename
#define GFX_FE_INVALID_MEDIA        21 // bad media
#define GFX_FE_SECTOR_READ_FAIL     22 // sector read failed
#define GFX_FE_SECTOR_WRITE_FAIL    23 // sector write failed
#define GFX_FE_FILE_TIMEOUT         26 // Timeout during file I/O, probable unexpected media removal

//------------------------------------------------------------------------------
// DISK struct offsets
//------------------------------------------------------------------------------
#define GFX_DISK_FIRST_SECT_LO      0 // DWORD address of the first sector of the FAT partition (LO word)
#define GFX_DISK_FIRST_SECT_HI      1 //       address of the first sector of the FAT partition (HI word)
#define GFX_DISK_FAT_LO             2 // DWORD address of FAT (LO word)
#define GFX_DISK_FAT_HI             3 //       address of FAT (HI word)
#define GFX_DISK_ROOT_LO            4 // DWORD address of root directory (LO word)
#define GFX_DISK_ROOT_HI            5 //       address of root directory (HI word)
#define GFX_DISK_DATA_LO            6 // DWORD address of data area (LO word)
#define GFX_DISK_DATA_HI            7 //       address of data area (HI word)
#define GFX_DISK_MAXCLUS_LO         8 // DWORD max number of clusters in partition (LO word)
#define GFX_DISK_MAXCLUS_HI         9 //       max number of clusters in partition (HI word)
#define GFX_DISK_MAXROOT            10 // WORD  max entries in root directory
#define GFX_DISK_FATSIZE            11 // WORD  number of sectors in FAT
#define GFX_DISK_FATCOPIES          12 // WORD  number of fat copies
#define GFX_DISK_SECT_PER_CLUS      13 // WORD  number of sectors per cluster
#define GFX_DISK_TYPE               14 // WORD  type of fat
#define GFX_DISK_BUF                15 // WORD  pointer to 512 byte info buffer

//------------------------------------------------------------------------------
// FILE struct offsets
//------------------------------------------------------------------------------
#define GFX_FILE_FIRST_CLUSTER      0 // WORD  first cluster
#define GFX_FILE_CURR_CLUSTER       1 // WORD  current cluster in file
#define GFX_FILE_CURR_SECTOR        2 // WORD  sector in current cluster
#define GFX_FILE_CURR_SECTOR_POS    3 // WORD  position in current sector
#define GFX_FILE_CURR_SECTOR_TOP    4 // WORD  number bytes in current sector buffer
#define GFX_FILE_SEEK_POS_LO        5 // DWORD position in the file (LO word)
#define GFX_FILE_SEEK_POS_HI        6 //       position in the file (HI word)
#define GFX_FILE_SIZE_LO            7 // DWORD file size (LO word)
#define GFX_FILE_SIZE_HI            8 //       file size (HI word)
#define GFX_FILE_TIME               9 // WORD  last update time
#define GFX_FILE_DATE               10 // WORD  last update date
#define GFX_FILE_NAME               11 // WORD  12 byte buffer for filename
#define GFX_FILE_MODE               17 // WORD  file mode 'r', 'w', 'a'
#define GFX_FILE_ATTRIBUTES         18 // WORD  files attributes
#define GFX_FILE_PAGEFLAG           19 // WORD  cache check flag
#define GFX_FILE_ENTRY              20 // WORD  entry position in cur directory
#define GFX_FILE_DISK               21 // WORD* pointer to DISK mount media structure
#define GFX_FILE_BUFFER             22 // WORD*  sector buffer



//------------------------------------------------------------------//
// pin counter mode constants                                       //
//------------------------------------------------------------------//
#define GFX_COUNT_OFF               0 // Disconnect the counter from the pin, "OVFfunction" is therefore ignored, and counting is inhibited.
#define GFX_COUNT_RISE              1 // increment counter on every rising edge
#define GFX_COUNT_FALL              2 // increment counter on every falling edge
#define GFX_COUNT_EDGE              3 // increment on every rising and falling edge


//------------------------------------------------------------------------------
// PWM Constants
//------------------------------------------------------------------------------
#define GFX_PWM_OFF                 0 
#define GFX_PWM_PLAIN               1 
#define GFX_PWM_SERVO               2 

//------------------------------------------------------------------//
// CONSTANTS
//------------------------------------------------------------------//

#define GFX_SPI1                    1 
#define GFX_SPI2                    2 
#define GFX_SPI3                    3 

// generic constants
#define GFX_ENABLE                  1 
#define GFX_DISABLE                 0 
#define GFX_HI                      1 
#define GFX_LO                      0 
#define GFX_ON                      1 
#define GFX_OFF                     0 
#define GFX_ALL                     0xFFFF // argument for img_xxx functions to update all images (and other uses)



//gfx_Get() related constants
#define GFX_X_MAX                   0 // current orientations screen maximum X co-ordinate
#define GFX_Y_MAX                   1 // current orientations screen maximum Y co-ordinate
#define GFX_LEFT_POS                2 // last objects left co-ord
#define GFX_TOP_POS                 3 // last objects top co-ord
#define GFX_RIGHT_POS               4 // last objects right co-ord
#define GFX_BOTTOM_POS              5 // last objects bottom co-ord
#define GFX_X_ORG                   6 // display position X offset
#define GFX_Y_ORG                   7 // display position X offset




#define GFX_SOLID                   0 // PEN_SIZE
#define GFX_OUTLINE                 1 // PEN_SIZE
#define GFX_STYLE1                  2 
#define GFX_STYLE2                  3 

#define GFX_LANDSCAPE               0 // SCREEN_MODE (north)
#define GFX_LANDSCAPE_R             1 // SCREEN_MODE (south)
#define GFX_PORTRAIT                2 // SCREEN_MODE (west)
#define GFX_PORTRAIT_R              3 // SCREEN_MODE (east)

#define GFX_COLOUR8                 1 // COLOUR_MODE 8 bit colour mode (not supported)
#define GFX_COLOUR16                0 // COLOUR_MODE 16 bit colour mode


#define GFX_CHECKED                 0 
#define GFX_UNCHECKED               1 


#define GFX_DOWN                    0 
#define GFX_UP                      1 
#define GFX_HIDE                    2 
#define GFX_HYPER                   3 // text only, no frame

#define GFX_BUTTON_DOWN             0 
#define GFX_BUTTON_UP               1 

#define GFX_SLIDER_SUNKEN           0 
#define GFX_SLIDER_RAISED           1 
#define GFX_SLIDER_HIDE             2 

#define GFX_PROGRESSBAR_RAISED      0xFFFF 
#define GFX_PROGRESSBAR_SUNKEN      0xFFFE 
#define GFX_PROGRESSBAR_HIDE        2 

#define GFX_PANEL_SUNKEN            0 
#define GFX_PANEL_RAISED            1 
#define GFX_PANEL_HIDE              2 
#define GFX_PANEL_FRAME             3 




// timer control  related constants
#define GFX_TIMER0                  0 
#define GFX_TIMER1                  1 
#define GFX_TIMER2                  2 
#define GFX_TIMER3                  3 
#define GFX_TIMER4                  4 
#define GFX_TIMER5                  5 
#define GFX_TIMER6                  6 
#define GFX_TIMER7                  7 



//------------------------------------------------------------------------------
// system WORD variables accesible with peekW and pokeW or pointer access
// Note that the txt_Set variables (0-15) and gfx_set variables (16-31)
// can also be accessed with peekW and pokeW
//------------------------------------------------------------------------------

#define GFX_RANDOM_LO               32 // random number generator LO word
#define GFX_RANDOM_HI               33 // random number generator LO word
#define GFX_SYSTEM_TIMER_LO         34 // 1msec 32 bit free running timer LO word
#define GFX_SYSTEM_TIMER_HI         35 // 1msec 32 bit free running timer HI word
#define GFX_TMR0                    36 // user timer0
#define GFX_TMR1                    37 // user timer1
#define GFX_TMR2                    38 // user timer2
#define GFX_TMR3                    39 // user timer3 (10msec resolution)
#define GFX_TMR4                    40 // user timer0
#define GFX_TMR5                    41 // user timer1
#define GFX_TMR6                    42 // user timer2
#define GFX_TMR7                    43 // user timer3 (10msec resolution)
#define GFX_SYS_X_MAX               44 // display hardware X res-1
#define GFX_SYS_Y_MAX               45 // display hardware Y res-1
#define GFX_GFX_XMAX                46 // current display width-1 determined by portrait / landscape swapping
#define GFX_GFX_YMAX                47 // current display width-1 determined by portrait / landscape swapping
#define GFX_GFX_LEFT                48 // virtual left point for most recent object
#define GFX_GFX_TOP                 49 // virtual top point for most recent object
#define GFX_GFX_RIGHT               50 // virtual right point for most recent object
#define GFX_GFX_BOTTOM              51 // virtual bottom point for most recent object
#define GFX_GFX_X1                  52 // clipped left point for current object
#define GFX_GFX_Y1                  53 // clipped top point for current object
#define GFX_GFX_X2                  54 // clipped right point for current object
#define GFX_GFX_Y2                  55 // clipped bottom point for current object
#define GFX_GFX_X_ORG               56 // current X origin
#define GFX_GFX_Y_ORG               57 // current Y origin

#define GFX_GFX_THUMB_PERCENT       75 // size of slider thumb as percentage
#define GFX_GFX_THUMB_BORDER_DARK   76 // darker shadow of thumb
#define GFX_GFX_THUMB_BORDER_LIGHT  77 // lighter shadow of thumb
#define GFX_TOUCH_XMINCAL           78 // touch calibration value
#define GFX_TOUCH_YMINCAL           79 // touch calibration value
#define GFX_TOUCH_XMAXCAL           80 // touch calibration value
#define GFX_TOUCH_YMAXCAL           81 // touch calibration value
#define GFX_IMG_WIDTH               82 // width of currently loaded image
#define GFX_IMG_HEIGHT              83 // height of currently loaded image
#define GFX_IMG_FRAME_DELAY         84 // 0 if image, else inter frame delay for movie
#define GFX_IMG_FLAGS               85 // bit 4 determines colour mode, other bits reserved
#define GFX_IMG_FRAME_COUNT         86 // count of frames in a movie
#define GFX_IMG_PIXEL_COUNT_LO      87 // count of pixels in the current frame
#define GFX_IMG_PIXEL_COUNT_HI      88 // count of pixels in the current frame
#define GFX_IMG_CURRENT_FRAME       89 // last frame shown
#define GFX_MEDIA_ADDRESS_LO        90 // uSD byte address LO
#define GFX_MEDIA_ADDRESS_HI        91 // uSD byte address HI
#define GFX_MEDIA_SECTOR_LO         92 // uSD sector address LO
#define GFX_MEDIA_SECTOR_HI         93 // uSD sector address HI
#define GFX_MEDIA_SECTOR_COUNT      94 // uSD number of bytes remaining in sector
#define GFX_TEXT_XPOS               95 // text current x pixel position
#define GFX_TEXT_YPOS               96 // text current y pixel position
#define GFX_TEXT_MARGIN             97 // text left pixel pos for carriage return
#define GFX_TXT_FONT_ID             98 // font type, 0 = system font, else pointer to user font
#define GFX_TXT_FONT_MAX            99 // max number of chars in font
#define GFX_TXT_FONT_OFFSET         100 // starting offset (normally 0x20)
#define GFX_TXT_FONT_WIDTH          101 // current font width
#define GFX_TXT_FONT_HEIGHT         102 // current font height
#define GFX_GFX_TOUCH_REGION_X1     103 // touch capture region
#define GFX_GFX_TOUCH_REGION_Y1     104 
#define GFX_GFX_TOUCH_REGION_X2     105 
#define GFX_GFX_TOUCH_REGION_Y2     106 
#define GFX_GFX_CLIP_LEFT_VAL       107 // left clipping point (set with gfx_ClipWindow(...)
#define GFX_GFX_CLIP_TOP_VAL        108 // top clipping point (set with gfx_ClipWindow(...)
#define GFX_GFX_CLIP_RIGHT_VAL      109 // right clipping point (set with gfx_ClipWindow(...)
#define GFX_GFX_CLIP_BOTTOM_VAL     110 // bottom clipping point (set with gfx_ClipWindow(...)
#define GFX_GFX_CLIP_LEFT           111 // current clip value (reads full size if clipping turned off)
#define GFX_GFX_CLIP_TOP            112 // current clip value (reads full size if clipping turned off)
#define GFX_GFX_CLIP_RIGHT          113 // current clip value (reads full size if clipping turned off)
#define GFX_GFX_CLIP_BOTTOM         114 // current clip value (reads full size if clipping turned off)
#define GFX_GRAM_PIXEL_COUNT_LO     115 // LO word of count of pixels in the set GRAM area
#define GFX_GRAM_PIXEL_COUNT_HI     116 // HI word of count of pixels in the set GRAM area
#define GFX_TOUCH_RAW_X             117 // 12 bit raw A2D X value from touch screen
#define GFX_TOUCH_RAW_Y             118 // 12 bit raw A2D Y value from touch screen
#define GFX_GFX_LAST_CHAR_WIDTH     119 // calculated char width from last call to charWidth function
#define GFX_GFX_LAST_CHAR_HEIGHT    120 // calculated height from last call to charHeight function
#define GFX_GFX_LAST_STR_WIDTH      121 // calculated width from last call to strWidth function
#define GFX_GFX_LAST_STR_HEIGHT     122 // calculated height from last call to strHeight function
#define GFX_PIN_COUNTER_PA4         123 // pin counter for PA4
#define GFX_PIN_COUNTER_PA5         124 // pin counter for PA5
#define GFX_PIN_COUNTER_PA6         125 // pin counter for PA6
#define GFX_PIN_COUNTER_PA7         126 // pin counter for PA7
#define GFX_PIN_COUNTER_PA8         127 // pin counter for PA8
#define GFX_PIN_COUNTER_PA9         128 // pin counter for PA9
#define GFX_PIN_EVENT_PA4           129 // pin counter rollover event for PA4
#define GFX_PIN_EVENT_PA5           130 // pin counter rollover event for PA5
#define GFX_PIN_EVENT_PA6           131 // pin counter rollover event for PA6
#define GFX_PIN_EVENT_PA7           132 // pin counter rollover event for PA7
#define GFX_PIN_EVENT_PA8           133 // pin counter rollover event for PA8
#define GFX_PIN_EVENT_PA9           134 // pin counter rollover event for PA9
#define GFX_QEN1_COUNTER_LO         135 // quadrature encoder #1 counter LO
#define GFX_QEN1_COUNTER_HI         136 // quadrature encoder #1 counter HI
#define GFX_QEN1_DELTA              137 // quadrature encoder #1 delta count, reset when read
#define GFX_QEN2_COUNTER_LO         138 // quadrature encoder #2 counter LO
#define GFX_QEN2_COUNTER_HI         139 // quadrature encoder #2 counter HI
#define GFX_QEN2_DELTA              140 // quadrature encoder #2 delta count, reset when read
#define GFX_FALSE_REASON            141 // explanation 'false' results, currently only for flash_ functions

//------------------------------------------------------------------//
// string processing constants                                      //
//------------------------------------------------------------------//
#define GFX_STR                     0x0080 // display as string
#define GFX_CHR                     0x0081 // display as single char


//============================================================================
// number formatting bits
//============================================================================
// bit 15 14 13 12 11 10 9  8  7  6  5  4  3  2  1  0
//     |  |  |  |   \___ ___/  |  \  /  \_____ _____/
//     |  |  |  |       V      |   V          V
//     |  |  |  |       |      |   |          |
//     |  |  |  |  digit count |   |          |
//     |  |  |  |  (nb 0 = 16) |   |          |____BASE (usually 2,10 or 16)
//     |  |  |  |              |   |
//     |  |  |  |              |   |___reserved (not used on Goldelox)
//     |  |  |  |              |
//     |  |  |  |              |____ string indicatior
//     |  |  |  |                      0x80 = [STR]
//     |  |  |  |                      0x81 = [CHR]
//     |  |  |  |______
//     |  |  |           1 = leading zeros included
//     |  |  |           0 = leading zeros suppressed
//     |  |  |
//     |  |  |_______
//     |  |           1 = leading zero blanking
//     |  |
//     |  |_____ sign bit (0 = signed, 1 = unsigned)
//     |
//     |______ 1 = space before unsigned number



  //=======================================================
  // general number formatting constants
  // for 'print' and 'putnum'
  //=======================================================
  // binary, no leading zeroes
#define GFX_BIN                     0x0002 // binary, 16 digits, no leading zeroes
#define GFX_BIN1                    0x0102 // binary, 1 digit, no leading zeroes
#define GFX_BIN2                    0x0202 // binary, 2 digits, no leading zeroes
#define GFX_BIN3                    0x0302 // binary, 3 digits, no leading zeroes
#define GFX_BIN4                    0x0402 // binary, 4 digits, no leading zeroes
#define GFX_BIN5                    0x0502 // binary, 5 digits, no leading zeroes
#define GFX_BIN6                    0x0602 // binary, 6 digits, no leading zeroes
#define GFX_BIN7                    0x0702 // binary, 7 digits, no leading zeroes
#define GFX_BIN8                    0x0802 // binary, 8 digits, no leading zeroes
#define GFX_BIN9                    0x0902 // binary, 9 digits, no leading zeroes
#define GFX_BIN10                   0x0A02 // binary, 10 digits, no leading zeroes
#define GFX_BIN11                   0x0B02 // binary, 11 digits, no leading zeroes
#define GFX_BIN12                   0x0C02 // binary, 12 digits, no leading zeroes
#define GFX_BIN13                   0x0D02 // binary, 13 digits, no leading zeroes
#define GFX_BIN14                   0x0E02 // binary, 14 digits, no leading zeroes
#define GFX_BIN15                   0x0F02 // binary, 15 digits, no leading zeroes
#define GFX_BIN16                   0x0002 // binary, 16 digits, no leading zeroes

  // binary, with leading zeroes
#define GFX_BINZ                    0x1002 // binary, 16 digits, leading zeroes
#define GFX_BIN1Z                   0x1102 // binary, 1 digit, leading zeroes
#define GFX_BIN2Z                   0x1202 // binary, 2 digits, leading zeroes
#define GFX_BIN3Z                   0x1302 // binary, 3 digits, leading zeroes
#define GFX_BIN4Z                   0x1402 // binary, 4 digits, leading zeroes
#define GFX_BIN5Z                   0x1502 // binary, 5 digits, leading zeroes
#define GFX_BIN6Z                   0x1602 // binary, 6 digits, leading zeroes
#define GFX_BIN7Z                   0x1702 // binary, 7 digits, leading zeroes
#define GFX_BIN8Z                   0x1802 // binary, 8 digits, leading zeroes
#define GFX_BIN9Z                   0x1902 // binary, 9 digits, leading zeroes
#define GFX_BIN10Z                  0x1A02 // binary, 10 digits, leading zeroes
#define GFX_BIN11Z                  0x1B02 // binary, 11 digits, leading zeroes
#define GFX_BIN12Z                  0x1C02 // binary, 12 digits, leading zeroes
#define GFX_BIN13Z                  0x1D02 // binary, 13 digits, leading zeroes
#define GFX_BIN14Z                  0x1E02 // binary, 14 digits, leading zeroes
#define GFX_BIN15Z                  0x1F02 // binary, 15 digits, leading zeroes
#define GFX_BIN16Z                  0x1002 // binary, 16 digits, leading zeroes

  // binary, with leading blanked
#define GFX_BINZB                   0x2002 // binary, 16 digits, leading blanks
#define GFX_BIN1ZB                  0x2102 // binary, 1 digit, leading blanks
#define GFX_BIN2ZB                  0x2202 // binary, 2 digits, leading blanks
#define GFX_BIN3ZB                  0x2302 // binary, 3 digits, leading blanks
#define GFX_BIN4ZB                  0x2402 // binary, 4 digits, leading blanks
#define GFX_BIN5ZB                  0x2502 // binary, 5 digits, leading blanks
#define GFX_BIN6ZB                  0x2602 // binary, 6 digits, leading blanks
#define GFX_BIN7ZB                  0x2702 // binary, 7 digits, leading blanks
#define GFX_BIN8ZB                  0x2802 // binary, 8 digits, leading blanks
#define GFX_BIN9ZB                  0x2902 // binary, 9 digits, leading blanks
#define GFX_BIN10ZB                 0x2A02 // binary, 10 digits, leading blanks
#define GFX_BIN11ZB                 0x2B02 // binary, 11 digits, leading blanks
#define GFX_BIN12ZB                 0x2C02 // binary, 12 digits, leading blanks
#define GFX_BIN13ZB                 0x2D02 // binary, 13 digits, leading blanks
#define GFX_BIN14ZB                 0x2E02 // binary, 14 digits, leading blanks
#define GFX_BIN15ZB                 0x2F02 // binary, 15 digits, leading blanks
#define GFX_BIN16ZB                 0x2002 // binary, 16 digits, leading blanks

  // signed decimal, no leading zeroes
#define GFX_DEC                     0x050A // signed decimal, 5 digits, no leading zeroes
#define GFX_DEC1                    0x010A // signed decimal, 1 digit, no leading zeroes
#define GFX_DEC2                    0x020A // signed decimal, 2 digits, no leading zeroes
#define GFX_DEC3                    0x030A // signed decimal, 3 digits, no leading zeroes
#define GFX_DEC4                    0x040A // signed decimal, 4 digits, no leading zeroes
#define GFX_DEC5                    0x050A // signed decimal, 5 digits, no leading zeroes

  // signed decimal, with leading zeroes
#define GFX_DECZ                    0x150A // signed decimal, 5 digits, leading zeroes
#define GFX_DEC1Z                   0x110A // signed decimal, 1 digit, leading zeroes
#define GFX_DEC2Z                   0x120A // signed decimal, 2 digits, leading zeroes
#define GFX_DEC3Z                   0x130A // signed decimal, 3 digits, leading zeroes
#define GFX_DEC4Z                   0x140A // signed decimal, 4 digits, leading zeroes
#define GFX_DEC5Z                   0x150A // signed decimal, 5 digits, leading zeroes

  // signed decimal, leading zeroes blanked
#define GFX_DECZB                   0x250A // signed decimal, 5 digits, leading blanks
#define GFX_DEC1ZB                  0x210A // signed decimal, 1 digit, leading blanks
#define GFX_DEC2ZB                  0x220A // signed decimal, 2 digits, leading blanks
#define GFX_DEC3ZB                  0x230A // signed decimal, 3 digits, leading blanks
#define GFX_DEC4ZB                  0x240A // signed decimal, 4 digits, leading blanks
#define GFX_DEC5ZB                  0x250A // signed decimal, 5 digits, leading blanks

  // unsigned decimal, no leading zeroes
#define GFX_UDEC                    0x450A // unsigned decimal, 5 digits, no leading zeroes
#define GFX_UDEC1                   0x410A // unsigned decimal, 1 digit, no leading zeroes
#define GFX_UDEC2                   0x420A // unsigned decimal, 2 digits, no leading zeroes
#define GFX_UDEC3                   0x430A // unsigned decimal, 3 digits, no leading zeroes
#define GFX_UDEC4                   0x440A // unsigned decimal, 4 digits, no leading zeroes
#define GFX_UDEC5                   0x450A // unsigned decimal, 5 digits, no leading zeroes

  // unsigned decimal, with leading zero's
#define GFX_UDECZ                   0x550A // unsigned decimal, 5 digits, leading zeroes
#define GFX_UDEC1Z                  0x510A // unsigned decimal, 1 digit, leading zeroes
#define GFX_UDEC2Z                  0x520A // unsigned decimal, 2 digits, leading zeroes
#define GFX_UDEC3Z                  0x530A // unsigned decimal, 3 digits, leading zeroes
#define GFX_UDEC4Z                  0x540A // unsigned decimal, 4 digits, leading zeroes
#define GFX_UDEC5Z                  0x550A // unsigned decimal, 5 digits, leading zeroes

  // unsigned decimal, leading zeroes blanked
#define GFX_UDECZB                  0x650A // unsigned decimal, 5 digits, leading blanks
#define GFX_UDEC1ZB                 0x610A // unsigned decimal, 1 digit, leading blanks
#define GFX_UDEC2ZB                 0x620A // unsigned decimal, 2 digits, leading blanks
#define GFX_UDEC3ZB                 0x630A // unsigned decimal, 3 digits, leading blanks
#define GFX_UDEC4ZB                 0x640A // unsigned decimal, 4 digits, leading blanks
#define GFX_UDEC5ZB                 0x650A // unsigned decimal, 5 digits, leading blanks

  // hex, with leading zero's
#define GFX_HEX                     0x1410 // hex, 4 digits, leading zeroes
#define GFX_HEX1                    0x1110 // hex, 1 digit, leading zeroes
#define GFX_HEX2                    0x1210 // hex, 2 digits, leading zeroes
#define GFX_HEX3                    0x1310 // hex, 3 digits, leading zeroes
#define GFX_HEX4                    0x1410 // hex, 4 digits, leading zeroes

  // hex, no leading zero's
#define GFX_HEXZ                    0x0410 // hex, 4 digits, no leading zeroes
#define GFX_HEX1Z                   0x0110 // hex, 1 digit, no leading zeroes
#define GFX_HEX2Z                   0x0210 // hex, 2 digits, no leading zeroes
#define GFX_HEX3Z                   0x0310 // hex, 3 digits, no leading zeroes
#define GFX_HEX4Z                   0x0410 // hex, 4 digits, no leading zeroes

  // hex, leading zero's blanked
#define GFX_HEXZB                   0x2410 // hex, 4 digits, leading blanks
#define GFX_HEX1ZB                  0x2110 // hex, 1 digit, leading blanks
#define GFX_HEX2ZB                  0x2210 // hex, 2 digits, leading blanks
#define GFX_HEX3ZB                  0x2310 // hex, 3 digits, leading blanks
#define GFX_HEX4ZB                  0x2410 // hex, 4 digits, leading blanks



//==================================================================================================



/*
    16 bit RGB (565) Colour Chart
    Original work by 4D Forum Member: skadoo
*/



#define GFX_ALICEBLUE               0xF7DF 
#define GFX_ANTIQUEWHITE            0xFF5A 
#define GFX_AQUA                    0x07FF 
#define GFX_AQUAMARINE              0x7FFA 
#define GFX_AZURE                   0xF7FF 
#define GFX_BEIGE                   0xF7BB 
#define GFX_BISQUE                  0xFF38 
#define GFX_BLACK                   0x0000 
#define GFX_BLANCHEDALMOND          0xFF59 
#define GFX_BLUE                    0x001F 
#define GFX_BLUEVIOLET              0x895C 
#define GFX_BROWN                   0xA145 
#define GFX_BURLYWOOD               0xDDD0 
#define GFX_CADETBLUE               0x5CF4 
#define GFX_CHARTREUSE              0x7FE0 
#define GFX_CHOCOLATE               0xD343 
#define GFX_CORAL                   0xFBEA 
#define GFX_CORNFLOWERBLUE          0x64BD 
#define GFX_CORNSILK                0xFFDB 
#define GFX_CRIMSON                 0xD8A7 
#define GFX_CYAN                    0x07FF 
#define GFX_DARKBLUE                0x0011 
#define GFX_DARKCYAN                0x0451 
#define GFX_DARKGOLDENROD           0xBC21 
#define GFX_DARKGRAY                0xAD55 
#define GFX_DARKGREEN               0x0320 
#define GFX_DARKKHAKI               0xBDAD 
#define GFX_DARKMAGENTA             0x8811 
#define GFX_DARKOLIVEGREEN          0x5345 
#define GFX_DARKORANGE              0xFC60 
#define GFX_DARKORCHID              0x9999 
#define GFX_DARKRED                 0x8800 
#define GFX_DARKSALMON              0xECAF 
#define GFX_DARKSEAGREEN            0x8DF1 
#define GFX_DARKSLATEBLUE           0x49F1 
#define GFX_DARKSLATEGRAY           0x2A69 
#define GFX_DARKTURQUOISE           0x067A 
#define GFX_DARKVIOLET              0x901A 
#define GFX_DEEPPINK                0xF8B2 
#define GFX_DEEPSKYBLUE             0x05FF 
#define GFX_DIMGRAY                 0x6B4D 
#define GFX_DODGERBLUE              0x1C9F 
#define GFX_FIREBRICK               0xB104 
#define GFX_FLORALWHITE             0xFFDE 
#define GFX_FORESTGREEN             0x2444 
#define GFX_FUCHSIA                 0xF81F 
#define GFX_GAINSBORO               0xDEFB 
#define GFX_GHOSTWHITE              0xFFDF 
#define GFX_GOLD                    0xFEA0 
#define GFX_GOLDENROD               0xDD24 
#define GFX_GRAY                    0x8410 
#define GFX_GREEN                   0x0400 
#define GFX_GREENYELLOW             0xAFE5 
#define GFX_HONEYDEW                0xF7FE 
#define GFX_HOTPINK                 0xFB56 
#define GFX_INDIANRED               0xCAEB 
#define GFX_INDIGO                  0x4810 
#define GFX_IVORY                   0xFFFE 
#define GFX_KHAKI                   0xF731 
#define GFX_LAVENDER                0xE73F 
#define GFX_LAVENDERBLUSH           0xFF9E 
#define GFX_LAWNGREEN               0x7FE0 
#define GFX_LEMONCHIFFON            0xFFD9 
#define GFX_LIGHTBLUE               0xAEDC 
#define GFX_LIGHTCORAL              0xF410 
#define GFX_LIGHTCYAN               0xE7FF 
#define GFX_LIGHTGOLD               0xFFDA 
#define GFX_LIGHTGREEN              0x9772 
#define GFX_LIGHTGREY               0xD69A 
#define GFX_LIGHTPINK               0xFDB8 
#define GFX_LIGHTSALMON             0xFD0F 
#define GFX_LIGHTSEAGREEN           0x2595 
#define GFX_LIGHTSKYBLUE            0x867F 
#define GFX_LIGHTSLATEGRAY          0x7453 
#define GFX_LIGHTSTEELBLUE          0xB63B 
#define GFX_LIGHTYELLOW             0xFFFC 
#define GFX_LIME                    0x07E0 
#define GFX_LIMEGREEN               0x3666 
#define GFX_LINEN                   0xFF9C 
#define GFX_MAGENTA                 0xF81F 
#define GFX_MAROON                  0x8000 
#define GFX_MEDIUMAQUAMARINE        0x6675 
#define GFX_MEDIUMBLUE              0x0019 
#define GFX_MEDIUMORCHID            0xBABA 
#define GFX_MEDIUMPURPLE            0x939B 
#define GFX_MEDIUMSEAGREEN          0x3D8E 
#define GFX_MEDIUMSLATEBLUE         0x7B5D 
#define GFX_MEDIUMSPRINGGREEN       0x07D3 
#define GFX_MEDIUMTURQUOISE         0x4E99 
#define GFX_MEDIUMVIOLETRED         0xC0B0 
#define GFX_MIDNIGHTBLUE            0x18CE 
#define GFX_MINTCREAM               0xF7FF 
#define GFX_MISTYROSE               0xFF3C 
#define GFX_MOCCASIN                0xFF36 
#define GFX_NAVAJOWHITE             0xFEF5 
#define GFX_NAVY                    0x0010 
#define GFX_OLDLACE                 0xFFBC 
#define GFX_OLIVE                   0x8400 
#define GFX_OLIVEDRAB               0x6C64 
#define GFX_ORANGE                  0xFD20 
#define GFX_ORANGERED               0xFA20 
#define GFX_ORCHID                  0xDB9A 
#define GFX_PALEGOLDENROD           0xEF55 
#define GFX_PALEGREEN               0x9FD3 
#define GFX_PALETURQUOISE           0xAF7D 
#define GFX_PALEVIOLETRED           0xDB92 
#define GFX_PAPAYAWHIP              0xFF7A 
#define GFX_PEACHPUFF               0xFED7 
#define GFX_PERU                    0xCC27 
#define GFX_PINK                    0xFE19 
#define GFX_PLUM                    0xDD1B 
#define GFX_POWDERBLUE              0xB71C 
#define GFX_PURPLE                  0x8010 
#define GFX_RED                     0xF800 
#define GFX_ROSYBROWN               0xBC71 
#define GFX_ROYALBLUE               0x435C 
#define GFX_SADDLEBROWN             0x8A22 
#define GFX_SALMON                  0xFC0E 
#define GFX_SANDYBROWN              0xF52C 
#define GFX_SEAGREEN                0x2C4A 
#define GFX_SEASHELL                0xFFBD 
#define GFX_SIENNA                  0xA285 
#define GFX_SILVER                  0xC618 
#define GFX_SKYBLUE                 0x867D 
#define GFX_SLATEBLUE               0x6AD9 
#define GFX_SLATEGRAY               0x7412 
#define GFX_SNOW                    0xFFDF 
#define GFX_SPRINGGREEN             0x07EF 
#define GFX_STEELBLUE               0x4416 
#define GFX_TAN                     0xD5B1 
#define GFX_TEAL                    0x0410 
#define GFX_THISTLE                 0xDDFB 
#define GFX_TOMATO                  0xFB08 
#define GFX_TURQUOISE               0x471A 
#define GFX_VIOLET                  0xEC1D 
#define GFX_WHEAT                   0xF6F6 
#define GFX_WHITE                   0xFFFF 
#define GFX_WHITESMOKE              0xF7BE 
#define GFX_YELLOW                  0xFFE0 
#define GFX_YELLOWGREEN             0x9E66 

#define GFX_Err4D_OK        0
#define GFX_Err4D_Timeout       1
#define GFX_Err4D_NAK       2 // other than ACK received

#define GFX_t4DWordArray            word *
#define GFX_t4DByteArray            char *
#define GFX_t4DSector               char *

#define GFX_F_blitComtoDisplay 35
#define GFX_F_bus_Read8 -122
#define GFX_F_bus_Write8 -121
#define GFX_F_charheight 29
#define GFX_F_charwidth 30
#define GFX_F_file_CallFunction 25
#define GFX_F_file_Close -431
#define GFX_F_file_Count 1
#define GFX_F_file_Dir 2
#define GFX_F_file_Erase 3
#define GFX_F_file_Error -424
#define GFX_F_file_Exec 4
#define GFX_F_file_Exists 5
#define GFX_F_file_FindFirst 6
#define GFX_F_file_FindFirstRet 36
#define GFX_F_file_FindNext -428
#define GFX_F_file_FindNextRet 37
#define GFX_F_file_GetC -441
#define GFX_F_file_GetS 7
#define GFX_F_file_GetW -443
#define GFX_F_file_Image -438
#define GFX_F_file_Index -434
#define GFX_F_file_LoadFunction 8
#define GFX_F_file_LoadImageControl 9
#define GFX_F_file_Mount -452
#define GFX_F_file_Open 10
#define GFX_F_file_PlayWAV 11
#define GFX_F_file_PutC 31
#define GFX_F_file_PutS 32
#define GFX_F_file_PutW -442
#define GFX_F_file_Read 12
#define GFX_F_file_Rewind -447
#define GFX_F_file_Run 13
#define GFX_F_file_ScreenCapture -439
#define GFX_F_file_Seek -433
#define GFX_F_file_Size 14
#define GFX_F_file_Tell 15
#define GFX_F_file_Unmount -453
#define GFX_F_file_Write 16
#define GFX_F_gfx_BevelShadow -196
#define GFX_F_gfx_BevelWidth -195
#define GFX_F_gfx_BGcolour -184
#define GFX_F_gfx_Button 17
#define GFX_F_gfx_ChangeColour -151
#define GFX_F_gfx_Circle -136
#define GFX_F_gfx_CircleFilled -137
#define GFX_F_gfx_Clipping -186
#define GFX_F_gfx_ClipWindow -150
#define GFX_F_gfx_Cls -126
#define GFX_F_gfx_Contrast -192
#define GFX_F_gfx_Ellipse -153
#define GFX_F_gfx_EllipseFilled -154
#define GFX_F_gfx_FrameDelay -189
#define GFX_F_gfx_Get -182
#define GFX_F_gfx_GetPixel -139
#define GFX_F_gfx_Line -131
#define GFX_F_gfx_LinePattern -193
#define GFX_F_gfx_LineTo -129
#define GFX_F_gfx_MoveTo -127
#define GFX_F_gfx_Orbit 18
#define GFX_F_gfx_OutlineColour -191
#define GFX_F_gfx_Panel -161
//#define GFX_F_gfx_PenSize -183
#define GFX_F_gfx_Polygon 19
#define GFX_F_gfx_PolygonFilled 20
#define GFX_F_gfx_Polyline 21
#define GFX_F_gfx_PutPixel -138
#define GFX_F_gfx_Rectangle -134
#define GFX_F_gfx_RectangleFilled -135
#define GFX_F_gfx_ScreenCopyPaste -163
#define GFX_F_gfx_ScreenMode -190
#define GFX_F_gfx_Set -125
#define GFX_F_gfx_SetClipRegion -152
#define GFX_F_gfx_Slider -162
#define GFX_F_gfx_Transparency -188
#define GFX_F_gfx_TransparentColour -187
#define GFX_F_gfx_Triangle -140
#define GFX_F_gfx_TriangleFilled -167
#define GFX_F_img_ClearAttributes -383
#define GFX_F_img_Darken -377
#define GFX_F_img_Disable -376
#define GFX_F_img_Enable -375
#define GFX_F_img_GetWord -380
#define GFX_F_img_Lighten -378
#define GFX_F_img_SetAttributes -382
#define GFX_F_img_SetPosition -374
#define GFX_F_img_SetWord -379
#define GFX_F_img_Show -381
#define GFX_F_img_Touched -384
#define GFX_F_media_Flush -218
#define GFX_F_media_Image -217
#define GFX_F_media_Init -219
#define GFX_F_media_RdSector 22
#define GFX_F_media_ReadByte -213
#define GFX_F_media_ReadWord -214
#define GFX_F_media_SetAdd -209
#define GFX_F_media_SetSector -210
#define GFX_F_media_Video -207
#define GFX_F_media_VideoFrame -208
#define GFX_F_media_WriteByte -215
#define GFX_F_media_WriteWord -216
#define GFX_F_media_WrSector 23
#define GFX_F_mem_Free -417
#define GFX_F_mem_Heap -418
#define GFX_F_peekM 39
#define GFX_F_pin_HI -113
#define GFX_F_pin_LO -114
#define GFX_F_pin_Read -116
#define GFX_F_pin_Set -112
#define GFX_F_pokeM 40
#define GFX_F_putCH -2
#define GFX_F_putstr 24
#define GFX_F_readString 34
#define GFX_F_setbaudWait 38
#define GFX_F_snd_BufSize -461
#define GFX_F_snd_Continue -464
#define GFX_F_snd_Pause -463
#define GFX_F_snd_Pitch -460
#define GFX_F_snd_Playing -465
#define GFX_F_snd_Stop -462
#define GFX_F_snd_Volume -459
#define GFX_F_sys_GetModel 26
#define GFX_F_sys_GetPmmC 28
#define GFX_F_sys_GetVersion 27
#define GFX_F_sys_Sleep -403
#define GFX_F_touch_DetectRegion -406
#define GFX_F_touch_Get -408
#define GFX_F_touch_Set -407
#define GFX_F_txt_Attributes -31
#define GFX_F_txt_BGcolour -19
#define GFX_F_txt_Bold -27
#define GFX_F_txt_FGcolour -18
#define GFX_F_txt_FontID -20
#define GFX_F_txt_Height -22
#define GFX_F_txt_Inverse -29
#define GFX_F_txt_Italic -28
#define GFX_F_txt_MoveCursor -16
#define GFX_F_txt_Opacity -26
#define GFX_F_txt_Set -17
#define GFX_F_txt_Underline -30
#define GFX_F_txt_Width -21
#define GFX_F_txt_Wrap -32
#define GFX_F_txt_Xgap -23
#define GFX_F_txt_Ygap -24
#define GFX_F_writeString 33

