#include "mbed.h"
#include <math.h>
#include <string.h>

#define M_PI 3.141592

Serial pc(SERIAL_TX, SERIAL_RX);

enum status {
    UNDEFINED, READING_PACKET, FINISHED_READING, PROCESSING_PACKET, CHECKING_INPUTS, ERROR_BUFFER_OVERFLOWN, POPULATING_SAMPLES, GENERATING_FUNCTION 
};

int main()
{
    char            buffer[20];                     // Input buffer
    unsigned short  pos = 0;                        // Position of buffer
    unsigned short  siz = 0;                        // Size of buffer
    
    unsigned short  status = 1;                     // Current status of program
    
    char*           container1;                     // Temporary containers that
    char*           container2;                     // hold sliced contents of
    char*           container3;                     // buffer
    char*           container4;
    char            delimiters[2] = {';', '!'};     // Delimiters for slicing
    
    char            type_of_func = '0';             // Type of function to be generated
    unsigned int    frequency = 0;                  // Frequency in Hz
    unsigned int    sample_rate = 0;                // Sample rate in Hz
    unsigned int    amplitude = 0;                  // Amplitude
    
    const           MAX_SAMPLE = 10000;
    uint8_t         samples[10000];                 // Array of samples at max rate

    pc.baud(115200);

    while (1) {
        
        printf("Input configuration packet:\n");
        
        while(status == READING_PACKET) {
            buffer[pos] = pc.getc();
            if(buffer[pos] == '!') {status = PROCESSING_PACKET; }
            if(pos == 20) {status = ERROR_BUFFER_OVERFLOWN; }
            ++pos; ++siz;
            if(status != READING_PACKET) {break; }
        }

        if(status == ERROR_BUFFER_OVERFLOWN) {
            printf("Error, configuration packet is too large. Maximum size is 20 characters.\n");
            for(int i = 0; i < 20; ++i) {buffer[i] = 0; }
            pos = 0; siz = 0;
            status = READING_PACKET;
        }

        if(status == PROCESSING_PACKET) {
            container1 = strtok(buffer, delimiters);
            container2 = strtok(NULL, delimiters);
            container3 = strtok(NULL, delimiters);
            container4 = strtok(NULL, delimiters);

            type_of_func = *container1;
            frequency = atoi(container2);
            sample_rate = atoi(container3);
            amplitude = atoi(container4);
            
            status = CHECKING_INPUTS;
        }
                
        if(status == CHECKING_INPUTS) {
            switch(type_of_func) {
            case 'S' : break;
            case 'Q' : break;
            case 'W' : break;
            default  :
                printf("Error, unrecognized or incorrectly entered type of function. Expected 'S' for Sine, 'Q' for Square or 'W' for Saw.\n");
                for(int i = 0; i < 20; ++i) {buffer[i] = 0; }
                pos = 0; siz = 0;
                status = READING_PACKET;
                break;
            }
            
            if((frequency > 10000) || (sample_rate > 10000) || (amplitude > 255)) {
                printf("Error, one or more values set too high. Maximum is 10 KHz for frequency and sample rate, 255 for amplitude.\n");
                for(int i = 0; i < 20; ++i) {buffer[i] = 0; }
                pos = 0; siz = 0;
                status = READING_PACKET;
            }
            
            status = POPULATING_SAMPLES;
        }
        
        if(status == POPULATING_SAMPLES) {
            switch(type_of_func) {
            case 'S' :
                for(int i = 0; i < 10000; ++i) {
                    samples[i] = (int) ((amplitude / 2) * (sin((i * frequency * 2 * M_PI) / 10000) + 1));
                }
                status = GENERATING_FUNCTION;
                break;
            case 'Q' : break;
            case 'W' : break;
            }
        }
        
        if(status == GENERATING_FUNCTION) {
            while(1) {
                for(int i = 0; i < 10000; ++i) {
                    printf("%d, ", samples[i * (10000 / sample_rate)]);
                    wait_us(100);
                }
            }
            
            //for(int i = 0; i < 20; ++i) {buffer[i] = 0; }
//            pos = 0; siz = 0;
//            status = READING_PACKET;
        }       
    }
}