#include "mbed.h"

//DigitalOut myled(LED1);
DigitalOut myled(P0_4);     //p2
RawSerial uart(P0_0, P0_1); //p8, p5

//8p:U0_TX, 5p:U0_RX
void SwitchMatrix_Init()    //generated by NXP Switch Matrix Tool
{ 
    /* Enable SWM clock */
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<7);

    /* Pin Assign 8 bit Configuration */
    /* U0_TXD */
    /* U0_RXD */
    LPC_SWM->PINASSIGN0 = 0xffff0100UL; 

    /* Pin Assign 1 bit Configuration */
    /* SWCLK */
    /* SWDIO */
    /* RESET */
    LPC_SWM->PINENABLE0 = 0xffffffb3UL; 
}

int main() {
    SwitchMatrix_Init();
    uart.baud(9600);
    char c;
    while(1) {
        if(uart.readable())
        {
            c = uart.getc();
            uart.putc(c);
        }
        myled = !myled;
    }
}
