//8x2 lcd
#include "I2cLCD.h"
#include "mbed.h"

#define    I2CLCD_ADDR    0xa0//0x7C

#define RS_CMD        0x00
#define RS_DATA       0x80
const short WAIT1 = 10;

I2cLCD::I2cLCD(PinName sda, PinName scl) :  _i2c( sda , scl ){
    //_i2c.frequency(50000);
    wait_ms(15);
    writeCommand(0x01);
    wait_ms(5);
    writeCommand(0x38);
    wait_ms(5);
    writeCommand(0x0f);
    wait_ms(5);
    writeCommand(0x06);
    wait_ms(5);
    writeCommand(0x0c);
    wait_ms(5);       
}



void I2cLCD::character(int column, int row, int c) {
    int a = address(column, row);
    writeCommand(a);
    writeData(c);
}

void I2cLCD::cls() {
    writeCommand(0x01); // cls, and set cursor to 0
    wait_ms(2);
    locate(0, 0);
}

void I2cLCD::locate(int column, int row) {
    _column = column;
    _row = row;
}

int I2cLCD::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= columns()) {
            _column = 0;
            _row++;
            if (_row >= rows()) {
                _row = 0;
            }
        }
    }
    return value;
}

int I2cLCD::_getc() {
    return -1;
}

void I2cLCD::writeCommand( int cmd )
{
    char cmds[2];
    
    cmds[0] = RS_CMD;
    cmds[1] = cmd;
    
    //_i2c.write(I2CLCD_ADDR, cmds, 2);
	_i2c.start();
	wait_us(9);
    _i2c.write(I2CLCD_ADDR);
	wait_us(WAIT1);
	_i2c.write(cmds[0]);
	wait_us(WAIT1);	
	_i2c.write(cmds[1]);
	wait_us(WAIT1);	
	_i2c.stop();
}

void I2cLCD::writeData( int data )
{
    char cmd[2];
    
    cmd[0] = RS_DATA;
    cmd[1] = data;
    
    //_i2c.write(I2CLCD_ADDR, cmd, 2);
	_i2c.start();
	wait_us(9);
    _i2c.write(I2CLCD_ADDR);
	wait_us(WAIT1);	
	_i2c.write(cmd[0]);
	wait_us(WAIT1);	
	_i2c.write(cmd[1]);
	wait_us(WAIT1);	
	_i2c.stop();

}

int I2cLCD::address(int column, int row) {

    return 0x80 + (row * 0x40) + column;
}

int I2cLCD::columns() {
    return 16;
}

int I2cLCD::rows() {
    return 2;
}
