#ifndef SENSOR_H
#define SENSOR_H
#include "mbed.h"
// ******************* Manual settings ******************************
#define EVERY               // *** every -> ss:D8 ***      
const int ROW_LEN = 1;      // *** set row length 1,8,16***
// ******************************************************************
// ******************************************************************
const int COL_LEN = 8;
const int CRI_LEN = 12;
// ************************** typedef ********************
typedef unsigned char byte;
// ********************** global function ****************
void out3bit(DigitalOut ary[], int val);
int noMinus(int n);
// *************************** Sensor *******************
class Sensor {
  public:
    Sensor(int correction = 0);
    void set_adAryInit();    
    void setAd(bool bAdd = false);
    int getColVal(int c);
    int getColAd(int c);

  private:
    unsigned int getAdc(int col);
    void setCol(int row, int col, bool bAdd=false);
    int ad2val(int ad);
    void pCri();
    void set_ILED_cycle_1200uS(Timer& t0, const int COL_US);

    static int cri[CRI_LEN];// criteria for value:1~12
    int adAry[COL_LEN];
    byte val12[COL_LEN];    // value 1~12
    static int adAryInit[ROW_LEN][COL_LEN];
};

#endif
