#include "mbed.h"
#include "CLED.h"
// *************************** CLED ********************************
const byte CLED::c10[7] = {0, 4, 5, 1, 3, 2, 6};//IHS10:none, red, yellow, green, lightBlue, bule, purple
const byte CLED::c11[7] = {0, 1, 3, 2, 6, 4, 5};//IHS11:none, red, yellow, green, lightBlue, bule, purple
const byte CLED::INDI_COLOR = 12;
// *************************** SPI ********************************
extern SPI spi;
extern DigitalOut ss;
extern Serial uart;
// *************************** GPIO ********************************
extern DigitalOut sel_sen;
extern DigitalOut fix_cled;
extern DigitalOut oe_cled;
// ************************* object ********************************
Ticker indiTic;

CLED::CLED(int ver) : inOn(false) {
    if (ver == 10) color = c10;
    if (ver == 11) color = c11;
    indiTic.attach(callback(this, &CLED::indiBlink), 400e-3);
    
}

void CLED::set(byte* ary12, bool indiRow) {        // 1-12[8]:{7, 3,..}
    int val24 = 0;
    for (int col = 0; col < COL_LEN; col++) {   // LED number is opposit direction
        bool isIndi = inOn && indiRow && (col == COL_LEN - 1) && (ary12[col] == 0);
        byte cVal = (isIndi ? INDI_COLOR : ary12[col]) >> 1;    
        val24 += color[cVal] << col * 3;
    }
    sel_sen = 0;                                //digitalWrite(sel_sen, LOW);
    oe_cled = 0;                                //digitalWrite(oe_cled, LOW);        
    ss = 0;                                     //digitalWrite(ss, LOW);
    for (int b = 2; b>=0; b--) {
        spi.write((val24 >> b * COL_LEN) & 0xff);
    }
    fix_cled = 1;       //digitalWrite(FIX_LED, HIGH);
    fix_cled = 0;       //digitalWrite(FIX_LED, LOW);      
    ss = 1;             //digitalWrite(ss, HIGH);
    oe_cled = 1;        //digitalWrite(oe_cled, HIGH);
}

void CLED::set(byte val12) {
    byte ary[COL_LEN];
    for (int i=0; i<COL_LEN; i++)
        ary[i] = val12;
    set(ary);
}

// *************** PWM callback function ****************
void CLED::indiBlink() {          // indicator blink
    inOn = !inOn;
}
