#ifndef CD40147_H
#define CD40147_H

/**
 * Handles the CD40147 chip and clones.  These are 10-4 line BCD Priority Encoders.
 * This simple interface lets you know which of the 10 pins, if any, is
 * connected to ground.  As per spec, the result can only tell you about the
 * highest valued pin which is grounded.  Note that pull-up resistors should
 * be connected to each pin so they are not left floating, which will lead to
 * unpredictable results.
 */
class CD40147 {
public:
    /**
     * Create an instance
     *
     * @param d0   Data input line for least significat bit (bit 0)
     * @param d1   Data input line for bit 1
     * @param d2   Data input line for bit 2
     * @param d3   Data input line for most significat bit (bit 3)
     */
    inline CD40147(PinName d0, PinName d1, PinName d2, PinName d3) :  _in(d0, d1, d2, d3) {}

    /**
     * Provides the highest valued input that was set, as this is a priority
     * encoder chip.  The value 0x0f means no pin is connected to ground.
     * Otherwise a value of 0-9 refers to pins 0-9 being grounded.
     */
    inline uint8_t read() {return (~_in.read()) & 0x0f;}

protected:
    BusIn _in;
};

#endif
